package binnie.core.machines.power;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum PowerSystem {
	MJ(100.0),
	RF(10.0),
	EU(40.0);

	double conversion;

	PowerSystem(final double conversion) {
		this.conversion = conversion;
	}

	public static PowerSystem get(final int i) {
		return values()[i % values().length];
	}

	public double convertTo(final int value) {
		return value / this.conversion;
	}

	public int convertFrom(final double value) {
		return (int) (value * this.conversion);
	}

	public String getUnitName() {
		return this.name();
	}

	public ItemStack saveTo(final ItemStack stack) {
		NBTTagCompound tag = stack.func_77978_p();
		if (tag == null) {
			tag = new NBTTagCompound();
		}
		tag.func_74774_a("power-system", (byte) this.ordinal());
		stack.func_77982_d(tag);
		return stack;
	}
}
