/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.Binnie;
import binnie.botany.api.genetics.EnumFlowerChromosome;
import binnie.core.BinnieCore;
import binnie.core.genetics.Tolerance;
import binnie.core.liquid.FluidContainerType;
import binnie.genetics.machine.acclimatiser.ToleranceSystem;
import binnie.genetics.machine.acclimatiser.ToleranceType;
import binnie.modules.ModuleManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class Acclimatiser {
    public static final int[] SLOT_RESERVE = new int[]{0, 1, 2, 3};
    public static final int SLOT_TARGET = 4;
    public static final int[] SLOT_ACCLIMATISER = new int[]{5, 6, 7};
    public static final int[] SLOT_DRONE = new int[]{8, 9, 10, 11};
    private static List<ToleranceSystem> toleranceSystems = new ArrayList<ToleranceSystem>();
    private static Map<ItemStack, Float> temperatureItems = new HashMap<ItemStack, Float>();
    private static Map<ItemStack, Float> humidityItems = new HashMap<ItemStack, Float>();

    @Nullable
    private static ToleranceSystem getToleranceSystem(ItemStack stack, ItemStack acclim) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root != null) {
            for (ToleranceSystem system : toleranceSystems) {
                if (!Objects.equals(root.getUID(), system.uid) || !system.type.hasEffect(acclim)) continue;
                return system;
            }
        }
        return null;
    }

    public static void addTolerance(String uid, IChromosomeType chromosome, ToleranceType type) {
        toleranceSystems.add(new ToleranceSystem(uid, chromosome, type));
    }

    public static float getTemperatureEffect(ItemStack item) {
        for (ItemStack stack : temperatureItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return temperatureItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static float getHumidityEffect(ItemStack item) {
        for (ItemStack stack : humidityItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return humidityItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static void addTemperatureItem(ItemStack itemstack, float amount) {
        if (itemstack.func_190926_b()) {
            return;
        }
        temperatureItems.put(itemstack, Float.valueOf(amount));
    }

    public static void addHumidityItem(ItemStack itemstack, float amount) {
        if (itemstack.func_190926_b()) {
            return;
        }
        humidityItems.put(itemstack, Float.valueOf(amount));
    }

    public static void setupRecipes() {
        if (BinnieCore.isApicultureActive()) {
            Acclimatiser.addTolerance(Binnie.GENETICS.getBeeRoot().getUID(), (IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE, ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.GENETICS.getBeeRoot().getUID(), (IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE, ToleranceType.Temperature);
        }
        if (BinnieCore.isLepidopteryActive()) {
            Acclimatiser.addTolerance(Binnie.GENETICS.getButterflyRoot().getUID(), (IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE, ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.GENETICS.getButterflyRoot().getUID(), (IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE, ToleranceType.Temperature);
        }
        if (ModuleManager.isEnabled("botany", "botany.flowers")) {
            Acclimatiser.addTolerance(Binnie.GENETICS.getFlowerRoot().getUID(), EnumFlowerChromosome.HUMIDITY_TOLERANCE, ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.GENETICS.getFlowerRoot().getUID(), EnumFlowerChromosome.TEMPERATURE_TOLERANCE, ToleranceType.Temperature);
            Acclimatiser.addTolerance(Binnie.GENETICS.getFlowerRoot().getUID(), EnumFlowerChromosome.PH_TOLERANCE, ToleranceType.PH);
        }
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151065_br), 0.5f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151072_bj), 0.75f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151129_at), 0.75f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151126_ay), -0.15f);
        Acclimatiser.addTemperatureItem(new ItemStack(Blocks.field_150432_aD), -0.75f);
        Acclimatiser.addHumidityItem(new ItemStack(Items.field_151131_as), 0.75f);
        Acclimatiser.addHumidityItem(new ItemStack((Block)Blocks.field_150354_m), -0.15f);
        Acclimatiser.addTemperatureItem(FluidContainerType.CAN.getFilled(FluidRegistry.LAVA), 0.75f);
        Acclimatiser.addTemperatureItem(FluidContainerType.REFRACTORY.getFilled(FluidRegistry.LAVA), 0.75f);
        Acclimatiser.addHumidityItem(FluidContainerType.CAN.getFilled(FluidRegistry.WATER), 0.75f);
        Acclimatiser.addHumidityItem(FluidContainerType.REFRACTORY.getFilled(FluidRegistry.WATER), 0.75f);
        Acclimatiser.addHumidityItem(FluidContainerType.CAPSULE.getFilled(FluidRegistry.WATER), 0.75f);
    }

    public static boolean canAcclimatise(ItemStack stack, List<ItemStack> acclimatisers) {
        if (stack.func_190926_b() || acclimatisers.isEmpty()) {
            return true;
        }
        for (ItemStack acclim : acclimatisers) {
            if (!Acclimatiser.canAcclimatise(stack, acclim)) continue;
            return true;
        }
        return false;
    }

    public static boolean canAcclimatise(ItemStack stack, ItemStack acclim) {
        ToleranceSystem system = Acclimatiser.getToleranceSystem(stack, acclim);
        return system != null && system.canAlter(stack, acclim);
    }

    public static ItemStack acclimatise(ItemStack stack, ItemStack acc) {
        ToleranceSystem system = Acclimatiser.getToleranceSystem(stack, acc);
        if (system == null) {
            return stack;
        }
        return system.alter(stack, acc);
    }

    public static Tolerance alterTolerance(Tolerance tol, float effect) {
        int[] bounds = tol.getBounds();
        int[] range = effect < 0.0f ? new int[]{bounds[0] - 1, bounds[1]} : new int[]{bounds[0], bounds[1] + 1};
        if (range[0] < -5) {
            range[0] = -5;
        }
        if (range[1] > 5) {
            range[1] = 5;
        }
        EnumTolerance[] up = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.UP_1, EnumTolerance.UP_2, EnumTolerance.UP_3, EnumTolerance.UP_4, EnumTolerance.UP_5};
        EnumTolerance[] down = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.DOWN_1, EnumTolerance.DOWN_2, EnumTolerance.DOWN_3, EnumTolerance.DOWN_4, EnumTolerance.DOWN_5};
        EnumTolerance[] both = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.BOTH_1, EnumTolerance.BOTH_2, EnumTolerance.BOTH_3, EnumTolerance.BOTH_4, EnumTolerance.BOTH_5};
        if (range[0] == 0) {
            return Tolerance.get(up[range[1]]);
        }
        if (range[1] == 0) {
            return Tolerance.get(down[-range[0]]);
        }
        int avg = (int)((float)(-range[0] + range[1]) / 2.0f + 0.6f);
        return Tolerance.get(both[avg]);
    }
}

