/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.infuser;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.infuser.InfuserLogic;
import binnie.extratrees.machines.infuser.TankValidatorInfuserInput;
import binnie.extratrees.machines.infuser.TankValidatorInfuserOutput;
import net.minecraft.tileentity.TileEntity;

public class InfuserMachine
extends ExtraTreeMachine.PackageExtraTreeMachine
implements IMachineInformation {
    public InfuserMachine() {
        super("infuser", ExtraTreeTexture.INFUSER, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.INFUSER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot input = tanks.addTank(0, "input", 5000);
        input.setValidator(new TankValidatorInfuserInput());
        input.setOutputSides(MachineSide.TopAndBottom);
        TankSlot output = tanks.addTank(1, "output", 5000);
        output.setValidator(new TankValidatorInfuserOutput());
        output.setReadOnly();
        output.setOutputSides(MachineSide.Sides);
        new ComponentPowerReceptor(machine);
        new InfuserLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

