/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.inventory.ValidatorSprite;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.recipes.ExtraTreesRecipeManager;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.brewery.recipes.BreweryRecipeManager;
import binnie.extratrees.machines.distillery.recipes.DistilleryRecipeManager;
import binnie.extratrees.machines.fruitpress.recipes.FruitPressRecipeManager;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipeManager;
import binnie.extratrees.machines.nursery.TileEntityNursery;
import binnie.modules.BinnieModule;
import binnie.modules.Module;
import binnie.modules.ModuleManager;
import forestry.api.core.Tabs;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

@BinnieModule(moduleID="extratrees.machines", moduleContainerID="extratrees", name="Machines", unlocalizedDescription="extratrees.module.machines")
public class ModuleMachine
extends Module {
    public static ValidatorSprite spritePolish;
    public static Block blockMachine;

    @Override
    public void setupAPI() {
        ExtraTreesRecipeManager.breweryManager = new BreweryRecipeManager();
        ExtraTreesRecipeManager.lumbermillManager = new LumbermillRecipeManager();
        ExtraTreesRecipeManager.fruitPressManager = new FruitPressRecipeManager();
        ExtraTreesRecipeManager.distilleryManager = new DistilleryRecipeManager();
    }

    @Override
    public void disabledSetupAPI() {
        super.disabledSetupAPI();
    }

    @Override
    public void registerItemsAndBlocks() {
        MachineGroup machineGroup = new MachineGroup(ExtraTrees.instance, "machine", "machine", ExtraTreeMachine.values());
        machineGroup.setCreativeTab(Tabs.tabArboriculture);
        blockMachine = machineGroup.getBlock();
        Object rendererMachine = null;
        BinnieCore.getBinnieProxy().registerTileEntity(TileEntityNursery.class, "binnie.tile.nursery", rendererMachine);
    }

    @Override
    public void init() {
        spritePolish = new ValidatorSprite(ExtraTrees.instance, "validator/polish.0", "validator/polish.1");
    }

    @Override
    public void postInit() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Lumbermill.get(1), new Object[]{"gAg", "GsG", "gPg", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('g'), ExtraTreeItems.ProvenGear.get(1), Character.valueOf('A'), Items.field_151036_c, Character.valueOf('s'), Mods.Forestry.stack("sturdy_machine"), Character.valueOf('P'), "gearBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Press.get(1), new Object[]{"iGi", "tSt", "tPt", Character.valueOf('i'), "ingotIron", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('t'), "ingotTin", Character.valueOf('S'), Mods.Forestry.stack("sturdy_machine"), Character.valueOf('P'), "gearBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.BREWERY.get(1), new Object[]{"bGb", "iSi", "bPb", Character.valueOf('i'), "ingotIron", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('b'), "gearBronze", Character.valueOf('S'), Mods.Forestry.stack("sturdy_machine"), Character.valueOf('P'), "gearBronze"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Distillery.get(1), new Object[]{"rGr", "iSi", "rPr", Character.valueOf('i'), "ingotIron", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('r'), "dustRedstone", Character.valueOf('S'), Mods.Forestry.stack("sturdy_machine"), Character.valueOf('P'), "gearBronze"}));
        if (ModuleManager.isEnabled("extratrees", "extratrees.carpentry")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Woodworker.get(1), new Object[]{"wGw", "GsG", "ggg", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('g'), ExtraTreeItems.ProvenGear.get(1), Character.valueOf('w'), Blocks.field_150344_f, Character.valueOf('s'), Mods.Forestry.stack("impregnated_casing")}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Panelworker.get(1), new Object[]{"wGw", "GsG", "ggg", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('g'), ExtraTreeItems.ProvenGear.get(1), Character.valueOf('w'), Blocks.field_150376_bx, Character.valueOf('s'), Mods.Forestry.stack("impregnated_casing")}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Glassworker.get(1), new Object[]{"wGw", "GsG", "ggg", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('g'), ExtraTreeItems.ProvenGear.get(1), Character.valueOf('w'), Blocks.field_150359_w, Character.valueOf('s'), Mods.Forestry.stack("impregnated_casing")}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ExtraTreeMachine.Tileworker.get(1), new Object[]{"wGw", "GsG", "ggg", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('g'), ExtraTreeItems.ProvenGear.get(1), Character.valueOf('w'), Items.field_151119_aD, Character.valueOf('s'), Mods.Forestry.stack("impregnated_casing")}));
        }
        LumbermillRecipeManager.calculateProducts();
    }
}

