/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.modules;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumFertiliserType;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.api.gardening.IGardeningManager;
import binnie.botany.blocks.BlockPlant;
import binnie.botany.blocks.BlockSoil;
import binnie.botany.core.BotanyCore;
import binnie.botany.items.BotanyItems;
import binnie.botany.items.ItemSoil;
import binnie.botany.items.ItemSoilMeter;
import binnie.botany.items.ItemTrowel;
import binnie.botany.items.ItemWeed;
import binnie.botany.recipes.CeramicTileRecipe;
import binnie.botany.recipes.PigmentRecipe;
import binnie.botany.tile.TileCeramic;
import binnie.botany.tile.TileCeramicBrick;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.item.ItemMisc;
import binnie.core.util.OreDictionaryUtil;
import binnie.modules.BinnieModule;
import binnie.modules.Module;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@BinnieModule(moduleID="botany.gardening", moduleContainerID="botany", name="Gardening", unlocalizedDescription="botany.module.gardening")
public class ModuleGardening
extends Module {
    public static BlockPlant plant;
    public static ItemTrowel trowelWood;
    public static ItemTrowel trowelStone;
    public static ItemTrowel trowelIron;
    public static ItemTrowel trowelDiamond;
    public static ItemTrowel trowelGold;
    public static BlockSoil soil;
    public static BlockSoil loam;
    public static BlockSoil flowerbed;
    public static BlockSoil soilNoWeed;
    public static BlockSoil loamNoWeed;
    public static BlockSoil flowerbedNoWeed;
    public static ItemSoilMeter soilMeter;
    public static ItemMisc misc;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        plant = new BlockPlant();
        soil = new BlockSoil(EnumSoilType.SOIL, "soil", false);
        loam = new BlockSoil(EnumSoilType.LOAM, "loam", false);
        flowerbed = new BlockSoil(EnumSoilType.FLOWERBED, "flowerbed", false);
        soilNoWeed = new BlockSoil(EnumSoilType.SOIL, "soil_no_weed", true);
        loamNoWeed = new BlockSoil(EnumSoilType.LOAM, "loam_no_weed", true);
        flowerbedNoWeed = new BlockSoil(EnumSoilType.FLOWERBED, "flowerbed_no_weed", true);
        soilMeter = new ItemSoilMeter();
        trowelWood = new ItemTrowel(Item.ToolMaterial.WOOD, "wood");
        trowelStone = new ItemTrowel(Item.ToolMaterial.STONE, "stone");
        trowelIron = new ItemTrowel(Item.ToolMaterial.IRON, "iron");
        trowelDiamond = new ItemTrowel(Item.ToolMaterial.DIAMOND, "diamond");
        trowelGold = new ItemTrowel(Item.ToolMaterial.GOLD, "gold");
        misc = new ItemMisc(CreativeTabBotany.instance, BotanyItems.values());
        Botany.proxy.registerBlock(plant, (ItemBlock)new ItemWeed((Block)plant));
        Botany.proxy.registerBlock(soil, (ItemBlock)new ItemSoil(soil));
        Botany.proxy.registerBlock(loam, (ItemBlock)new ItemSoil(loam));
        Botany.proxy.registerBlock(flowerbed, (ItemBlock)new ItemSoil(flowerbed));
        Botany.proxy.registerBlock(soilNoWeed, (ItemBlock)new ItemSoil(soilNoWeed));
        Botany.proxy.registerBlock(loamNoWeed, (ItemBlock)new ItemSoil(loamNoWeed));
        Botany.proxy.registerBlock(flowerbedNoWeed, (ItemBlock)new ItemSoil(flowerbedNoWeed));
        Botany.proxy.registerItem(soilMeter);
        Botany.proxy.registerItem(trowelWood);
        Botany.proxy.registerItem(trowelStone);
        Botany.proxy.registerItem(trowelIron);
        Botany.proxy.registerItem(trowelDiamond);
        Botany.proxy.registerItem(trowelGold);
        Botany.proxy.registerItem(misc);
        BinnieCore.getBinnieProxy().registerTileEntity(TileCeramic.class, "botany.tile.ceramic");
        BinnieCore.getBinnieProxy().registerTileEntity(TileCeramicBrick.class, "botany.tile.ceramicBrick");
        OreDictionary.registerOre((String)"weedkiller", (ItemStack)BotanyItems.WEEDKILLER.get(1));
        OreDictionary.registerOre((String)"toolTrowel", (Item)trowelWood);
        OreDictionary.registerOre((String)"toolTrowel", (Item)trowelStone);
        OreDictionary.registerOre((String)"toolTrowel", (Item)trowelIron);
        OreDictionary.registerOre((String)"toolTrowel", (Item)trowelGold);
        OreDictionary.registerOre((String)"toolTrowel", (Item)trowelDiamond);
    }

    @Override
    public void init() {
        RecipeSorter.register((String)"botany:ceramictile", CeramicTileRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        RecipeSorter.register((String)"botany:pigment", PigmentRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
    }

    @Override
    public void postInit() {
        IGardeningManager gardening = BotanyCore.getGardening();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)trowelWood, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "plankWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)trowelStone, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "cobblestone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)trowelIron, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)trowelGold, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "ingotGold"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)trowelDiamond, new Object[]{"d  ", " x ", "  s", Character.valueOf('d'), Blocks.field_150346_d, Character.valueOf('s'), "stickWood", Character.valueOf('x'), "gemDiamond"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)soilMeter, new Object[]{" gg", " rg", "i  ", Character.valueOf('g'), "ingotGold", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron"}));
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.WEEDKILLER.get(4), (Object[])new Object[]{new ItemStack(Items.field_151070_bp), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151014_N)});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_ASH.get(4), (Object[])new Object[]{Mods.Forestry.stack("ash")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_MULCH.get(4), (Object[])new Object[]{Mods.Forestry.stack("mulch")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_COMPOST.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizer_bio")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_FERTILISER.get(4), (Object[])new Object[]{Mods.Forestry.stack("fertilizer_compound")});
        GameRegistry.addShapelessRecipe((ItemStack)BotanyItems.POWDER_PULP.get(4), (Object[])new Object[]{Mods.Forestry.stack("wood_pulp")});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(BotanyItems.POWDER_SULPHUR.get(4), new Object[]{"dustSulphur"}));
        gardening.registerFertiliser(EnumFertiliserType.ACID, BotanyItems.POWDER_SULPHUR.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.ACID, BotanyItems.POWDER_MULCH.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.ACID, Mods.Forestry.stack("mulch"), 2);
        for (ItemStack stack : OreDictionary.getOres((String)"dustSulfur")) {
            gardening.registerFertiliser(EnumFertiliserType.ACID, stack, 2);
        }
        gardening.registerFertiliser(EnumFertiliserType.ALKALINE, BotanyItems.POWDER_ASH.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.ALKALINE, BotanyItems.POWDER_PULP.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.ALKALINE, Mods.Forestry.stack("ash"), 2);
        gardening.registerFertiliser(EnumFertiliserType.ALKALINE, Mods.Forestry.stack("wood_pulp"), 2);
        gardening.registerFertiliser(EnumFertiliserType.NUTRIENT, BotanyItems.POWDER_COMPOST.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.NUTRIENT, BotanyItems.POWDER_FERTILISER.get(1), 1);
        gardening.registerFertiliser(EnumFertiliserType.NUTRIENT, Mods.Forestry.stack("fertilizer_bio"), 2);
        gardening.registerFertiliser(EnumFertiliserType.NUTRIENT, Mods.Forestry.stack("fertilizer_compound"), 2);
        this.addFertiliserRecipes();
    }

    private ItemStack getStack(EnumSoilType type, EnumAcidity pH, EnumMoisture moisture, boolean weedkiller) {
        IGardeningManager gardeningManager = BotanyCore.getGardening();
        return new ItemStack(gardeningManager.getSoilBlock(type, weedkiller), 1, BlockSoil.getMeta(pH, moisture));
    }

    private void addFertiliserRecipes() {
        IGardeningManager gardening = BotanyCore.getGardening();
        for (EnumMoisture moisture : EnumMoisture.values()) {
            for (EnumAcidity acidity : EnumAcidity.values()) {
                int pH = acidity.ordinal();
                for (EnumSoilType type : EnumSoilType.values()) {
                    Map<EnumFertiliserType, Map<ItemStack, Integer>> fertilisers = gardening.getFertilisers();
                    for (EnumFertiliserType fertiliserType : EnumFertiliserType.values()) {
                        for (Map.Entry<ItemStack, Integer> entry : fertilisers.get((Object)fertiliserType).entrySet()) {
                            ItemStack stack = entry.getKey();
                            int strengthMax = entry.getValue();
                            for (boolean weedkiller : new boolean[]{false, true}) {
                                int numOfBlocks = strengthMax * strengthMax;
                                for (int strength = 1; strength < strengthMax; ++strength) {
                                    int endPh = fertiliserType == EnumFertiliserType.ACID ? pH - strength : (fertiliserType == EnumFertiliserType.ALKALINE ? pH + strength : type.ordinal() + strength);
                                    if (endPh < 0 || endPh > 2 || pH == endPh) continue;
                                    ItemStack start = this.getStack(type, acidity, moisture, weedkiller);
                                    ItemStack end = this.getStack(type, EnumAcidity.values()[endPh], moisture, weedkiller);
                                    if (!start.func_190926_b() && !end.func_190926_b()) {
                                        end.func_190920_e(numOfBlocks);
                                        Object[] stacks = new Object[numOfBlocks + 1];
                                        for (int i = 0; i < numOfBlocks; ++i) {
                                            stacks[i] = start;
                                        }
                                        stacks[numOfBlocks] = stack.func_77946_l();
                                        GameRegistry.addShapelessRecipe((ItemStack)end, (Object[])stacks);
                                    }
                                    numOfBlocks /= 2;
                                }
                            }
                        }
                    }
                    ItemStack start = this.getStack(type, acidity, moisture, false);
                    ItemStack end = this.getStack(type, acidity, moisture, true);
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(end, new Object[]{start, start, start, start, "weedkiller"}));
                }
            }
        }
    }

    @SubscribeEvent
    public void onFertiliseSoil(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b()) {
            return;
        }
        IGardeningManager gardening = BotanyCore.getGardening();
        if (!gardening.isSoil(block = world.func_180495_p(event.getPos()).func_177230_c())) {
            pos = pos.func_177977_b();
            block = world.func_180495_p(pos).func_177230_c();
        }
        if (!gardening.isSoil(block)) {
            return;
        }
        IBlockSoil soil = (IBlockSoil)block;
        if (gardening.onFertiliseSoil(heldItem, soil, world, pos, player)) {
            return;
        }
        if (OreDictionaryUtil.hasOreName(heldItem, "weedkiller") && gardening.addWeedKiller(world, pos) && !player.field_71075_bZ.field_75098_d) {
            heldItem.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent event) {
        IBlockSoil soil;
        IGardeningManager gardening = BotanyCore.getGardening();
        BlockPos pos = event.getPos();
        Block block = event.getBlock().func_177230_c();
        if (gardening.isSoil(block) && (soil = (IBlockSoil)block).fertilise(event.getWorld(), pos, EnumSoilType.LOAM)) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

