/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.blocks;

import binnie.botany.Botany;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.api.genetics.IFlowerGenome;
import binnie.botany.api.genetics.IFlowerRoot;
import binnie.botany.api.genetics.IFlowerType;
import binnie.botany.blocks.properties.PropertyFlower;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.FlowerDefinition;
import binnie.botany.models.StateMapperFlower;
import binnie.botany.modules.ModuleFlowers;
import binnie.botany.network.PacketID;
import binnie.botany.tile.TileEntityFlower;
import binnie.core.BinnieCore;
import binnie.core.network.packet.MessageNBT;
import binnie.core.util.TileUtil;
import com.mojang.authlib.GameProfile;
import forestry.api.core.IStateMapperRegister;
import forestry.core.blocks.IColoredBlock;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlower
extends BlockContainer
implements IColoredBlock,
IStateMapperRegister {
    public static final AxisAlignedBB FLOWER_BLOCK_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
    public static final PropertyFlower FLOWER = new PropertyFlower<IFlowerType>("flower", IFlowerType.class);
    public static final PropertyInteger SECTION = PropertyInteger.func_177719_a((String)"section", (int)0, (int)(EnumFlowerType.highestSection - 1));
    public static final PropertyBool FLOWERED = PropertyBool.func_177716_a((String)"flowered");
    public static final PropertyBool SEED = PropertyBool.func_177716_a((String)"seed");

    public BlockFlower() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.setRegistryName("flower");
        this.func_149672_a(SoundType.field_185850_c);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFlower();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperFlower());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_190926_b() || heldItem.func_77973_b() != BinnieCore.getFieldKit() || !player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityFlower)) {
            return true;
        }
        TileEntityFlower tileFlower = (TileEntityFlower)tile;
        IFlower flower = tileFlower.getFlower();
        if (flower == null) {
            return true;
        }
        IFlowerGenome flowerGenome = flower.getGenome();
        NBTTagCompound info = new NBTTagCompound();
        info.func_74778_a("Species", flowerGenome.getPrimary().getUID());
        info.func_74778_a("Species2", flowerGenome.getSecondary().getUID());
        info.func_74776_a("Age", (float)(flower.getAge() / flowerGenome.getLifespan()));
        info.func_74777_a("Colour", (short)flowerGenome.getPrimaryColor().getID());
        info.func_74777_a("Colour2", (short)flowerGenome.getSecondaryColor().getID());
        info.func_74757_a("Wilting", flower.isWilted());
        info.func_74757_a("Flowered", flower.hasFlowered());
        Botany.proxy.sendToPlayer(new MessageNBT(PacketID.FIELDKIT.ordinal(), info), player);
        heldItem.func_77972_a(1, (EntityLivingBase)player);
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityFlower flower;
        TileEntity tile = source.func_175625_s(pos);
        if (tile instanceof TileEntityFlower && (flower = (TileEntityFlower)tile).getType().getSections() > 1) {
            return field_185505_j;
        }
        return FLOWER_BLOCK_AABB.func_191194_a(state.func_191059_e(source, pos));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
        TileEntity flower = world.func_175625_s(pos);
        if (!BinnieCore.getBinnieProxy().isSimulating(world)) {
            IFlower f;
            if (flower != null && flower instanceof TileEntityFlower && (f = flowerRoot.getMember(stack)) != null) {
                ((TileEntityFlower)flower).setRender(new TileEntityFlower.RenderInfo(f, (TileEntityFlower)flower));
            }
            return;
        }
        TileEntity below = world.func_175625_s(pos.func_177977_b());
        if (flower != null && flower instanceof TileEntityFlower) {
            if (below instanceof TileEntityFlower) {
                ((TileEntityFlower)flower).setSection(((TileEntityFlower)below).getSection());
            } else {
                GameProfile owner = placer instanceof EntityPlayer ? ((EntityPlayer)placer).func_146103_bH() : null;
                ((TileEntityFlower)flower).create(stack, owner);
            }
        }
        flowerRoot.tryGrowSection(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        TileEntity tile;
        if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TileEntityFlower) {
            TileEntityFlower flower = (TileEntityFlower)tile;
            if (tintIndex == 0) {
                return flower.getStemColour();
            }
            if (tintIndex == 1) {
                return flower.getPrimaryColour();
            }
            return flower.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        if (tile instanceof TileEntityFlower && ((TileEntityFlower)tile).getSection() > 0) {
            return downState.func_177230_c() == ModuleFlowers.flower;
        }
        return this.canPlaceBlockOn(downState.func_177230_c());
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || BotanyCore.getGardening().isSoil(block);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityFlower flower = TileUtil.getTile(world, pos, TileEntityFlower.class);
        if (flower != null && flower.getType() != null) {
            state = state.func_177226_a((IProperty)FLOWER, (Comparable)flower.getType());
            state = state.func_177226_a((IProperty)FLOWERED, (Comparable)Boolean.valueOf(flower.isFlowered()));
            state = state.func_177226_a((IProperty)SECTION, (Comparable)Integer.valueOf(flower.getRenderSection()));
            state = state.func_177226_a((IProperty)SEED, (Comparable)Boolean.valueOf(flower.getAge() == 0));
        } else {
            state = state.func_177226_a((IProperty)FLOWER, (Comparable)FlowerDefinition.Dandelion.getSpecies().getType());
            state = state.func_177226_a((IProperty)FLOWERED, (Comparable)Boolean.valueOf(false));
            state = state.func_177226_a((IProperty)SEED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FLOWER, FLOWERED, SECTION, SEED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityFlower flower;
        this.checkAndDropBlock(worldIn, pos);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityFlower && (flower = (TileEntityFlower)tile).getSection() == 0 && flower.getFlower() != null && flower.getFlower().getAge() > 0 && flower.getFlower().getGenome().getPrimary().getType().getSections() > 1 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != ModuleFlowers.flower) {
            this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFlower) {
            ((TileEntityFlower)tile).randomUpdate(rand);
            this.checkAndDropBlock(world, pos);
            return;
        }
        world.func_175698_g(pos);
    }

    protected void checkAndDropBlock(World world, BlockPos pos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack flower;
        NonNullList drops = NonNullList.func_191196_a();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFlower && ((TileEntityFlower)tile).getSection() == 0 && !(flower = ((TileEntityFlower)tile).getItemStack()).func_190926_b()) {
            drops.add((Object)flower);
        }
        return drops;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        NonNullList<ItemStack> drops = this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
        boolean hasBeenBroken = world.func_175698_g(pos);
        if (hasBeenBroken && BinnieCore.getBinnieProxy().isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack drop : drops) {
                BlockFlower.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
        return hasBeenBroken;
    }
}

