/*
 * Decompiled with CFR 0.152.
 */
package binnie.modules;

import binnie.core.AbstractMod;
import binnie.modules.IModuleContainer;
import binnie.modules.Module;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public abstract class BlankModuleContainer
extends AbstractMod
implements IModuleContainer {
    protected Set<Module> loadedModules = new LinkedHashSet<Module>();
    protected Set<Module> unloadedModules = new LinkedHashSet<Module>();
    protected Set<String> enabledModules = new LinkedHashSet<String>();
    protected Set<String> disabledModules = new LinkedHashSet<String>();
    protected File configFolder;
    @Nullable
    private SimpleNetworkWrapper wrapper;

    @Override
    public void preInit() {
        super.preInit();
        this.configFolder = new File(Loader.instance().getConfigDir(), "forestry/" + this.getModID());
    }

    public final boolean isModuleEnabled(String moduleUID) {
        return this.enabledModules.contains(moduleUID);
    }

    @Override
    public String getID() {
        return this.getModID();
    }

    @Override
    public File getConfigFolder() {
        return this.configFolder;
    }

    @Override
    public Set<String> getEnabledModules() {
        return this.enabledModules;
    }

    @Override
    public void enableModule(String uid) {
        this.enabledModules.add(uid);
    }

    @Override
    public void disableModule(String uid) {
        this.disabledModules.add(uid);
    }

    @Override
    public Set<Module> getLoadedModules() {
        return this.loadedModules;
    }

    @Override
    public Set<Module> getUnloadedModules() {
        return this.unloadedModules;
    }
}

