/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill.recipes;

import binnie.core.util.FakeCraftingWorld;
import binnie.core.util.OreDictionaryUtil;
import binnie.extratrees.api.recipes.ILumbermillManager;
import binnie.extratrees.api.recipes.ILumbermillRecipe;
import binnie.extratrees.integration.jei.lumbermill.LumbermillRecipeWrapper;
import binnie.extratrees.machines.lumbermill.recipes.LumbermillRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.oredict.OreDictionary;

public class LumbermillRecipeManager
implements ILumbermillManager {
    private static Multimap<Item, ILumbermillRecipe> recipes = ArrayListMultimap.create();

    public static ItemStack getPlankProduct(ItemStack logStack) {
        if (recipes.isEmpty()) {
            LumbermillRecipeManager.calculateProducts();
        }
        Item logItem = logStack.func_77973_b();
        for (ILumbermillRecipe recipe : recipes.get((Object)logItem)) {
            if (!recipe.getInput().func_77969_a(logStack)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static void calculateProducts() {
        CraftingManager craftingManager = CraftingManager.func_77594_a();
        InventoryCrafting fakeCraftingInventory = new InventoryCrafting(new FakeCraftingHandler(), 3, 3){};
        NonNullList logs = OreDictionary.getOres((String)"logWood");
        for (ItemStack logStack : logs) {
            if (logStack.func_77952_i() == Short.MAX_VALUE) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack logCopy = logStack.func_77946_l();
                    logCopy.func_190920_e(1);
                    logCopy.func_77964_b(i);
                    fakeCraftingInventory.func_174888_l();
                    fakeCraftingInventory.func_70299_a(0, logCopy);
                    ItemStack recipeOutput = craftingManager.func_82787_a(fakeCraftingInventory, (World)FakeCraftingWorld.getInstance());
                    if (recipeOutput.func_190926_b() || !OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) continue;
                    LumbermillRecipeManager.addLogToPlankRecipe(logCopy.func_77946_l(), recipeOutput.func_77946_l());
                }
                continue;
            }
            fakeCraftingInventory.func_174888_l();
            fakeCraftingInventory.func_70299_a(0, logStack.func_77946_l());
            ItemStack recipeOutput = craftingManager.func_82787_a(fakeCraftingInventory, (World)FakeCraftingWorld.getInstance());
            if (recipeOutput.func_190926_b() || !OreDictionaryUtil.hasOreName(recipeOutput, "plankWood")) continue;
            LumbermillRecipeManager.addLogToPlankRecipe(logStack.func_77946_l(), recipeOutput.func_77946_l());
        }
    }

    private static void addLogToPlankRecipe(ItemStack logStack, ItemStack plankStack) {
        Item logItem = logStack.func_77973_b();
        plankStack.func_190920_e((int)Math.ceil((float)plankStack.func_190916_E() * 1.5f));
        recipes.put((Object)logItem, (Object)new LumbermillRecipe(logStack, plankStack));
    }

    @Override
    public void addRecipe(ItemStack input, ItemStack output) {
        Item logItem = input.func_77973_b();
        recipes.put((Object)logItem, (Object)new LumbermillRecipe(input, output));
    }

    @Override
    public boolean addRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.put((Object)item, (Object)recipe);
    }

    @Override
    public boolean removeRecipe(ILumbermillRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.get((Object)item).remove(recipe);
    }

    @Override
    public Collection<ILumbermillRecipe> recipes() {
        return recipes.values();
    }

    @Override
    public String getJEICategory() {
        return "binnie.extratrees.lumbermill";
    }

    @Override
    @Nullable
    public Object getJeiWrapper(ILumbermillRecipe recipe) {
        if (!Loader.isModLoaded((String)"jei")) {
            return null;
        }
        return this.getWrapper(recipe);
    }

    @Optional.Method(modid="jei")
    private Object getWrapper(ILumbermillRecipe recipe) {
        return new LumbermillRecipeWrapper(recipe.getInput(), recipe.getOutput());
    }

    private static class FakeCraftingHandler
    extends Container {
        private FakeCraftingHandler() {
        }

        public void func_75130_a(IInventory inventoryIn) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }
}

