/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.item;

import binnie.core.item.IItemMiscProvider;
import binnie.core.item.ItemCore;
import forestry.api.core.IModelManager;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMisc
extends ItemCore {
    private IItemMiscProvider[] items;

    public ItemMisc(CreativeTabs tab, IItemMiscProvider[] items, String name) {
        super(name);
        this.func_77637_a(tab);
        this.func_77627_a(true);
        this.func_77655_b(name);
        this.items = items;
    }

    public ItemMisc(CreativeTabs tab, IItemMiscProvider[] items) {
        this(tab, items, "misc");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs creativeTabs, NonNullList<ItemStack> subItems) {
        for (IItemMiscProvider item : this.items) {
            if (!item.isActive()) continue;
            subItems.add((Object)this.getStack(item, 1));
        }
    }

    private IItemMiscProvider getItem(int damage) {
        return damage >= this.items.length ? this.items[0] : this.items[damage];
    }

    public ItemStack getStack(IItemMiscProvider type, int size) {
        return new ItemStack((Item)this, size, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        IItemMiscProvider item = this.getItem(stack.func_77952_i());
        item.addInformation(tooltip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (IItemMiscProvider type : this.items) {
            manager.registerItemModel(item, type.ordinal(), "misc/" + type.getModelPath());
        }
    }

    public String func_77653_i(ItemStack stack) {
        IItemMiscProvider item = this.getItem(stack.func_77952_i());
        return item.getDisplayName(stack);
    }
}

