/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.crafttweaker.handlers;

import binnie.core.api.IBinnieRecipe;
import binnie.core.api.ICraftingManager;
import binnie.core.util.ItemStackUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GenericRecipeHandler {
    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipe(ItemStack output, M manager) {
        Collection<R> recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getOutputs()) {
                ItemStack itemStack;
                if (!(o instanceof ItemStack) || !ItemStackUtil.isItemEqual(itemStack = (ItemStack)o, output, true, false)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        MineTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipeInput(ItemStack input, M manager) {
        Collection<R> recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getInputs()) {
                ItemStack itemStack;
                if (!(o instanceof ItemStack) || !ItemStackUtil.isItemEqual(itemStack = (ItemStack)o, input, true, false)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        MineTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipe(FluidStack output, M manager) {
        Collection<R> recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getOutputs()) {
                FluidStack fluidStack;
                if (!(o instanceof FluidStack) || !(fluidStack = (FluidStack)o).isFluidEqual(output)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        MineTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipeInput(FluidStack input, M manager) {
        Collection<R> recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getInputs()) {
                FluidStack fluidStack;
                if (!(o instanceof FluidStack) || !(fluidStack = (FluidStack)o).isFluidEqual(input)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        MineTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void addRecipe(R recipe, M manager) {
        MineTweakerAPI.apply(new Add<R, M>(recipe, manager));
    }

    private static class Remove<R extends IBinnieRecipe, M extends ICraftingManager<R>>
    implements IUndoableAction {
        private final List<R> recipes;
        private final M manager;

        public Remove(List<R> recipes, M manager) {
            this.recipes = recipes;
            this.manager = manager;
        }

        public void apply() {
            Iterator<R> rIterator = this.recipes.iterator();
            while (rIterator.hasNext()) {
                IBinnieRecipe recipe = (IBinnieRecipe)rIterator.next();
                if (this.manager.removeRecipe((IBinnieRecipe)recipe)) {
                    Object recipeWrapper = this.manager.getJeiWrapper((IBinnieRecipe)recipe);
                    if (recipeWrapper == null) continue;
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(recipeWrapper, this.manager.getJEICategory());
                    continue;
                }
                rIterator.remove();
            }
        }

        public void undo() {
            for (IBinnieRecipe recipe : this.recipes) {
                Object recipeWrapper;
                if (!this.manager.addRecipe((IBinnieRecipe)recipe) || (recipeWrapper = this.manager.getJeiWrapper((IBinnieRecipe)recipe)) == null) continue;
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(recipeWrapper, this.manager.getJEICategory());
            }
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.manager.toString() + " recipe for " + this.recipes.toString();
        }

        public Object getOverrideKey() {
            return null;
        }

        public String describeUndo() {
            return "Adding " + this.manager.toString() + " recipe for " + this.recipes.toString();
        }
    }

    private static class Add<R extends IBinnieRecipe, M extends ICraftingManager<R>>
    implements IUndoableAction {
        private final R recipe;
        private final M manager;

        public Add(R recipe, M manager) {
            this.recipe = recipe;
            this.manager = manager;
        }

        public void apply() {
            Object recipeWrapper;
            if (this.manager.addRecipe(this.recipe) && (recipeWrapper = this.manager.getJeiWrapper(this.recipe)) != null) {
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe(recipeWrapper, this.manager.getJEICategory());
            }
        }

        public void undo() {
            Object recipeWrapper;
            if (this.manager.removeRecipe(this.recipe) && (recipeWrapper = this.manager.getJeiWrapper(this.recipe)) != null) {
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe(recipeWrapper, this.manager.getJEICategory());
            }
        }

        public boolean canUndo() {
            return true;
        }

        public String describeUndo() {
            return "Removing " + this.manager.toString() + " recipe for " + this.recipe.toString();
        }

        public Object getOverrideKey() {
            return null;
        }

        public String describe() {
            return "Adding " + this.manager.toString() + " recipe for " + this.recipe.toString();
        }
    }
}

