/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gui.database;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.IFlowerColor;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.gui.database.ControlColorOption;
import binnie.botany.gui.database.PageColorMix;
import binnie.botany.gui.database.PageColorMixResultant;
import binnie.botany.gui.database.PageSpeciesFlowerGenome;
import binnie.core.AbstractMod;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.minecraft.Window;
import binnie.core.util.I18N;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowBotanistDatabase
extends WindowAbstractDatabase {
    private ControlListBox<EnumFlowerColor> selectionBoxColors;

    public WindowBotanistDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.GENETICS.flowerBreedingSystem, 130);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowBotanistDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.overview", 0));
        new PageSpeciesFlowerGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "genome.title", 0));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.classification", 0));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.resultant", 0));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.further", 0));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Botany.instance, "branches.overview", 0));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Botany.instance, "branches.species", 0));
        this.createMode(FlowerMode.Color, new FlowerColorModeWidgets());
        new PageColorMixResultant((IWidget)this.getInfoPages(FlowerMode.Color), new DatabaseTab(Botany.instance, "color.resultant", 0));
        new PageColorMix((IWidget)this.getInfoPages(FlowerMode.Color), new DatabaseTab(Botany.instance, "color.further", 0));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(Botany.instance, "breeder", 0));
    }

    @Override
    protected AbstractMod getMod() {
        return Botany.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "FlowerDatabase";
    }

    @SideOnly(value=Side.CLIENT)
    private class FlowerColorModeWidgets
    extends WindowAbstractDatabase.ModeWidgets {
        public FlowerColorModeWidgets() {
            super(FlowerMode.Color, WindowBotanistDatabase.this);
        }

        @Override
        public void createListBox(Area area) {
            this.listBox = new ControlListBox<IFlowerColor>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                @Override
                public IWidget createOption(IFlowerColor value, int y) {
                    return new ControlColorOption((ControlList)this.getContent(), value, y);
                }
            };
            List colors = Arrays.stream(EnumFlowerColor.values()).map(c -> c.getFlowerColorAllele()).collect(Collectors.toList());
            this.listBox.setOptions(colors);
        }
    }

    static enum FlowerMode implements IDatabaseMode
    {
        Color;


        @Override
        public String getName() {
            return I18N.localise("botany.gui.database.tab." + this.name().toLowerCase());
        }
    }
}

