package binnie.genetics.item;

import javax.annotation.Nonnull;
import java.util.List;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;

import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsGUI;

public class ItemBeeDictionary extends Item implements IItemModelRegister {

	public ItemBeeDictionary() {
		this.func_77637_a(Tabs.tabApiculture);
		this.func_77655_b("dictionary");
		this.func_77625_d(1);
		setRegistryName("dictionary");
		func_77627_a(true);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		super.func_77624_a(stack, playerIn, tooltip, advanced);
		if (stack.func_77952_i() > 0) {
			tooltip.add("Flora-in-a-box");
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(final Item itemIn, final CreativeTabs tab, final NonNullList<ItemStack> subItems) {
		super.func_150895_a(itemIn, tab, subItems);
		subItems.add(new ItemStack(itemIn, 1, 1));
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		final ItemStack itemStack = playerIn.func_184586_b(handIn);
		final GeneticsGUI id;
		if (itemStack.func_77952_i() == 0) {
			id = GeneticsGUI.BEE_DATABASE;
		} else {
			id = GeneticsGUI.BEE_DATABASE_NEI;
		}
		Genetics.proxy.openGui(id, playerIn, playerIn.func_180425_c());

		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	@Nonnull
	public String func_77653_i(@Nonnull ItemStack i) {
		return (i.func_77952_i() == 0) ? "Apiarist Database" : "Master Apiarist Database";
	}

	@Override
	@SideOnly(Side.CLIENT)
	@SuppressWarnings("all")
	public void registerModel(Item item, IModelManager manager) {
		ModelLoader.setCustomModelResourceLocation(this, 0, new ModelResourceLocation(getRegistryName(), "inventory"));
		ModelLoader.setCustomModelResourceLocation(this, 1, new ModelResourceLocation(getRegistryName().toString() + "_master", "inventory"));
	}
}
