package binnie.extratrees.machines.brewery.recipes;

import javax.annotation.Nullable;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import net.minecraftforge.fluids.FluidStack;

import forestry.api.core.INbtWritable;

import binnie.extratrees.api.recipes.IBreweryCrafting;

public class BreweryCrafting implements INbtWritable, IBreweryCrafting {
	@Nullable
	public FluidStack inputFluid;
	@Nullable
	public ItemStack[] inputGrains;
	public ItemStack ingredient;
	public ItemStack yeast;

	public BreweryCrafting( @Nullable final FluidStack inputFluid, final ItemStack ingredient, @Nullable final ItemStack[] inputGrains, final ItemStack yeast) {
		this.inputFluid = inputFluid;
		this.inputGrains = ((inputGrains == null) ? new ItemStack[3] : inputGrains);
		this.ingredient = ingredient;
		this.yeast = yeast;
	}

	public static BreweryCrafting create(final NBTTagCompound nbt) {
		FluidStack inputFluid = FluidStack.loadFluidStackFromNBT(nbt.func_74775_l("fluid"));
		ItemStack ingredient = new ItemStack(nbt.func_74775_l("ingr"));
		ItemStack[] inputGrains = new ItemStack[]{
			new ItemStack(nbt.func_74775_l("in1")),
			new ItemStack(nbt.func_74775_l("in2")),
			new ItemStack(nbt.func_74775_l("in3"))
		};
		ItemStack yeast = new ItemStack(nbt.func_74775_l("yeast"));
		return new BreweryCrafting(inputFluid, ingredient, inputGrains, yeast);
	}
	
	public boolean hasInputGrainsEmpty(){
		return inputGrains == null || (isEmptyStack(inputGrains[0]) && isEmptyStack(inputGrains[1]) && isEmptyStack(inputGrains[2]));
	}

	private boolean isEmptyStack(ItemStack stack){
		return stack == null || stack.func_190926_b();
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound nbt) {
		if (this.inputFluid != null) {
			final NBTTagCompound fluidTag = new NBTTagCompound();
			this.inputFluid.writeToNBT(fluidTag);
			nbt.func_74782_a("fluid", fluidTag);
		}
		nbt.func_74782_a("ingr", this.getNBT(this.ingredient));
		nbt.func_74782_a("in1", this.getNBT(this.inputGrains[0]));
		nbt.func_74782_a("in2", this.getNBT(this.inputGrains[1]));
		nbt.func_74782_a("in3", this.getNBT(this.inputGrains[2]));
		nbt.func_74782_a("yeast", this.getNBT(this.yeast));
		return nbt;
	}

	private NBTTagCompound getNBT(final ItemStack ingr) {
		if (ingr.func_190926_b()) {
			return new NBTTagCompound();
		}
		final NBTTagCompound nbt = new NBTTagCompound();
		ingr.func_77955_b(nbt);
		return nbt;
	}

	@Nullable
	public FluidStack getInputFluid() {
		return inputFluid;
	}

	@Nullable
	public ItemStack[] getInputGrains() {
		return inputGrains;
	}

	public ItemStack getIngredient() {
		return ingredient;
	}

	public ItemStack getYeast() {
		return yeast;
	}
}
