package binnie.extrabees.worldgen;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.blocks.BlockExtraBeeHive;
import binnie.extrabees.blocks.type.EnumHiveType;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

import java.util.Random;

public class WorldGenHiveNether extends WorldGenHive {

	public WorldGenHiveNether(int rate) {
		super(rate);
	}

	@Override
	public boolean func_180709_b(final World world, final Random random, final BlockPos pos) {
		final Biome biome = world.func_180494_b(pos);
		if (!BiomeDictionary.hasType(biome, BiomeDictionary.Type.NETHER)) {
			return true;
		}
		if (this.embedInWall(world, Blocks.field_150424_aL, pos)) {
			world.func_175656_a(pos, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, EnumHiveType.Nether));
		}
		return true;
	}

	public boolean embedInWall(final World world, final Block blockID, final BlockPos pos) {
		if (world.func_180495_p(pos).func_177230_c() != blockID) {
			return false;
		}
		for (EnumFacing facing : EnumFacing.field_82609_l) {
			if (facing.func_176740_k() == EnumFacing.Axis.Y && world.func_180495_p(pos.func_177984_a()).func_177230_c() != blockID) {
				return false;
			}
			if (world.func_175623_d(pos.func_177972_a(facing))) {
				return true;
			}
		}
		return false;
	}
}
