/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.button;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.button.ControlButton;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventValueChanged;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ControlEnumButton<T>
extends ControlButton
implements IControlValue<T> {
    public static final String eventEnumChanged = "eventEnumButtonChanged";
    private T currentSelection;
    private List<T> enumConstants;

    public ControlEnumButton(IWidget parent, int x, int y, int width, int height, T[] values) {
        super(parent, x, y, width, height, "");
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0, (Object)"Tried to create ControlEnumButton with no values.");
        this.enumConstants = new ArrayList<T>();
        Collections.addAll(this.enumConstants, values);
        this.currentSelection = values[0];
    }

    @Override
    public String getText() {
        return this.currentSelection.toString();
    }

    @Override
    public void onMouseClick(EventMouse.Down event) {
        int index = this.enumConstants.indexOf(this.currentSelection);
        index = index < this.enumConstants.size() - 1 ? ++index : 0;
        T newEnum = this.enumConstants.get(index);
        this.setValue(newEnum);
    }

    @Override
    public T getValue() {
        return this.currentSelection;
    }

    @Override
    public void setValue(T selection) {
        if (this.currentSelection != selection) {
            this.currentSelection = selection;
            this.callEvent(new EventValueChanged<T>(this, this.getValue()));
        }
    }
}

