/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.IFluidType;
import binnie.genetics.Genetics;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum GeneticLiquid implements IFluidType
{
    GrowthMedium("Growth Medium", "growth.medium", 15460533),
    Bacteria("Bacteria", "bacteria", 14203521),
    BacteriaPoly("Polymerising Bacteria", "bacteria.poly", 11443396),
    RawDNA("Raw DNA", "dna.raw", 15089129),
    BacteriaVector("Bacteria Vector", "bacteria.vector", 15960958);

    String name;
    String ident;
    int colour;
    float transparency;

    private GeneticLiquid(String name, String ident, int colour) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = 1.0f;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public ResourceLocation getFlowing() {
        return new ResourceLocation(Genetics.instance.getModID(), "blocks/liquids/" + this.ident.replace(".", "_"));
    }

    @Override
    public ResourceLocation getStill() {
        return new ResourceLocation(Genetics.instance.getModID(), "blocks/liquids/" + this.ident.replace(".", "_"));
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return 0xFFFFFF;
    }

    @Override
    public int getContainerColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.LIQUID.getFluidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public boolean canPlaceIn(FluidContainerType container) {
        return this == GrowthMedium || container == FluidContainerType.CYLINDER;
    }

    @Override
    public boolean showInCreative(FluidContainerType container) {
        return container == FluidContainerType.CYLINDER;
    }
}

