/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery.recipes;

import binnie.extratrees.api.recipes.IBreweryCrafting;
import binnie.extratrees.api.recipes.IBreweryRecipe;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BreweryRecipe
implements IBreweryRecipe {
    private final FluidStack input;
    private final FluidStack output;
    private final ItemStack yeast;

    public BreweryRecipe(FluidStack input, FluidStack output, ItemStack specificYeast) {
        this.input = input;
        this.output = output;
        this.yeast = specificYeast;
    }

    @Override
    @Nullable
    public FluidStack getOutput(IBreweryCrafting crafting) {
        if (!this.yeast.func_77969_a(crafting.getYeast())) {
            return null;
        }
        if (!crafting.hasInputGrainsEmpty()) {
            return null;
        }
        if (!crafting.getIngredient().func_190926_b()) {
            return null;
        }
        if (this.input.isFluidEqual(crafting.getInputFluid())) {
            return this.output.copy();
        }
        return null;
    }

    @Override
    public FluidStack getInput() {
        return this.input;
    }

    @Override
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public boolean isGrain(ItemStack itemStack) {
        return false;
    }

    @Override
    public List<ItemStack> getGrains() {
        return Collections.emptyList();
    }

    @Override
    public boolean isIngredient(ItemStack itemStack) {
        return false;
    }

    @Override
    public List<ItemStack> getIngredients() {
        return Collections.emptyList();
    }

    @Override
    public ItemStack getYeast() {
        return this.yeast;
    }
}

