/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.gui.IBinnieGUID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.network.IPacketProvider;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.proxy.IProxyCore;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AbstractMod
implements IPacketProvider,
IInitializable {
    protected List<IInitializable> modules = new ArrayList<IInitializable>();
    @Nullable
    private SimpleNetworkWrapper wrapper;

    public AbstractMod() {
        BinnieCore.registerMod(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected abstract void registerModules();

    public abstract boolean isActive();

    @Override
    public abstract String getChannel();

    @Override
    public IPacketID[] getPacketIDs() {
        return new IPacketID[0];
    }

    public IBinnieGUID[] getGUIDs() {
        return new IBinnieGUID[0];
    }

    public Class<?>[] getConfigs() {
        return new Class[0];
    }

    public abstract IProxyCore getProxy();

    public abstract String getModID();

    public SimpleNetworkWrapper getNetworkWrapper() {
        Preconditions.checkState((this.wrapper != null ? 1 : 0) != 0, (Object)"Tried to get network wrapper before it has been init.");
        return this.wrapper;
    }

    protected abstract Class<? extends BinniePacketHandler> getPacketHandler();

    public Object getMod() {
        return this;
    }

    @Override
    public void preInit() {
        this.getProxy().setMod(this);
        if (!this.isActive()) {
            this.disabledSetupAPI();
            return;
        }
        this.setupAPI();
        this.registerModules();
        for (Class<?> cls : this.getConfigs()) {
            Binnie.CONFIGURATION.registerConfiguration(cls, this);
        }
        this.getProxy().preInit();
        for (IInitializable module : this.modules) {
            module.preInit();
        }
        this.getProxy().registerModels();
    }

    @Override
    public void init() {
        if (!this.isActive()) {
            this.disabledSetupAPI();
            return;
        }
        this.getProxy().init();
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(this.getChannel());
        this.wrapper.registerMessage(this.getPacketHandler(), MessageBinnie.class, 1, Side.CLIENT);
        this.wrapper.registerMessage(this.getPacketHandler(), MessageBinnie.class, 1, Side.SERVER);
        for (IInitializable module : this.modules) {
            module.init();
        }
        this.getProxy().registerItemAndBlockColors();
    }

    @Override
    public void postInit() {
        if (!this.isActive()) {
            this.disabledSetupAPI();
            return;
        }
        this.getProxy().postInit();
        for (IInitializable module : this.modules) {
            module.postInit();
        }
    }

    protected final void addModule(IInitializable init) {
        this.modules.add(init);
        MinecraftForge.EVENT_BUS.register((Object)init);
    }
}

