package binnie.extratrees.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;

import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.core.ExtraTreesGUID;

public class ItemMothDatabase extends Item implements IItemModelRegister {

	public ItemMothDatabase() {
		func_77637_a(Tabs.tabLepidopterology);
		func_77655_b("databaseLepi");
		setRegistryName("databaseLepi");
		func_77625_d(1);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0, "lepi_database");
		manager.registerItemModel(item, 1, "master_lepi_database");
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		if (isMaster(stack)) {
			tooltip.add(TextFormatting.DARK_PURPLE + I18N.localise("extratrees.item.database.lepi.master.tooltip"));
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> subItems) {
		super.func_150895_a(item, tab, subItems);
		subItems.add(new ItemStack(item, 1, 1));
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
		ItemStack itemStack = player.func_184586_b(hand);
		final ExtraTreesGUID id;
		if (isMaster(itemStack)) {
			id = ExtraTreesGUID.MOTH_DATABASE_NEI;
		} else {
			id = ExtraTreesGUID.MOTH_DATABASE;
		}

		ExtraTrees.proxy.openGui(id, player, player.func_180425_c());

		return new ActionResult(EnumActionResult.PASS, itemStack);
	}

	@Override
	public String func_77653_i(ItemStack itemStack) {
		return I18N.localise("extratrees.item.database.lepi." + (isMaster(itemStack) ? "master.name" : "name"));
	}

	protected boolean isMaster(ItemStack itemStack) {
		return itemStack.func_77960_j() > 0;
	}
}
