package binnie.core.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMetadata extends ItemBlock {
	public ItemMetadata(final Block block) {
		super(block);
	}

	@Override
	public int func_77647_b(final int damage) {
		return 0;
	}

	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
		if (!(field_150939_a instanceof IBlockMetadata)) {
			return false;
		}
		int placedMeta = ((IBlockMetadata) field_150939_a).getPlacedMeta(stack, world, pos, side);
		if (placedMeta < 0) {
			return false;
		}
		if (!world.func_180501_a(pos, newState, 3)) {
			return false;
		}
		if (world.func_180495_p(pos).func_177230_c() == field_150939_a) {
			TileEntityMetadata tile = TileEntityMetadata.getTile(world, pos);
			if (tile != null) {
				tile.setTileMetadata(placedMeta, false);
			}
			func_179224_a(world, player, pos, stack);
			field_150939_a.func_180633_a(world, pos, newState, player, stack);
		}
		return true;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public String func_77653_i(ItemStack itemStack) {
		return ((IBlockMetadata) field_150939_a).getDisplayName(itemStack);
	}
}
