/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.analyser;

import binnie.Binnie;
import binnie.genetics.api.IItemAnalysable;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Analyser {
    public static final int[] SLOT_RESERVE = new int[]{0, 1, 2, 3, 4, 5};
    public static final int SLOT_TARGET = 6;
    public static final int[] SLOT_FINISHED = new int[]{7, 8, 9, 10, 11, 12};
    public static final int SLOT_DYE = 13;

    public static boolean isAnalysable(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        return ind != null || stack.func_77973_b() instanceof IItemAnalysable || Binnie.GENETICS.getConversion(stack) != null;
    }

    public static boolean isAnalysed(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        if (ind != null) {
            return ind.isAnalyzed();
        }
        return stack.func_77973_b() instanceof IItemAnalysable && ((IItemAnalysable)stack.func_77973_b()).isAnalysed(stack);
    }

    public static ItemStack analyse(ItemStack stack, World world, GameProfile username) {
        if (!stack.func_190926_b()) {
            ISpeciesRoot root;
            ItemStack conv = Binnie.GENETICS.getConversionStack(stack).func_77946_l();
            if (!conv.func_190926_b()) {
                conv.func_190920_e(stack.func_190916_E());
                stack = conv;
            }
            if ((root = AlleleManager.alleleRegistry.getSpeciesRoot(stack)) != null) {
                IIndividual ind = root.getMember(stack);
                ind.analyze();
                IBreedingTracker breedingTracker = ind.getGenome().getSpeciesRoot().getBreedingTracker(world, username);
                breedingTracker.registerBirth(ind);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                ind.writeToNBT(nbttagcompound);
                stack.func_77982_d(nbttagcompound);
                return stack;
            }
            if (stack.func_77973_b() instanceof IItemAnalysable) {
                return ((IItemAnalysable)stack.func_77973_b()).analyse(stack);
            }
        }
        return stack;
    }
}

