/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei;

import binnie.core.integration.jei.Drawables;
import binnie.genetics.Genetics;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.api.IItemChargeable;
import binnie.genetics.integration.jei.database.DatabaseRecipeCategory;
import binnie.genetics.integration.jei.database.DatabaseRecipeMaker;
import binnie.genetics.integration.jei.genepool.GenepoolRecipeCategory;
import binnie.genetics.integration.jei.genepool.GenepoolRecipeMaker;
import binnie.genetics.integration.jei.incubator.IncubatorRecipeCategory;
import binnie.genetics.integration.jei.incubator.IncubatorRecipeWrapper;
import binnie.genetics.integration.jei.incubator.LarvaeIncubatorRecipeCategory;
import binnie.genetics.integration.jei.incubator.LarvaeIncubatorRecipeMaker;
import binnie.genetics.integration.jei.inoculator.InoculatorRecipeCategory;
import binnie.genetics.integration.jei.inoculator.InoculatorRecipeMaker;
import binnie.genetics.integration.jei.inoculator.SplicerRecipeCategory;
import binnie.genetics.integration.jei.isolator.IsolatorRecipeCategory;
import binnie.genetics.integration.jei.isolator.IsolatorRecipeMaker;
import binnie.genetics.integration.jei.polymeriser.PolymeriserRecipeCategory;
import binnie.genetics.integration.jei.polymeriser.PolymeriserRecipeMaker;
import binnie.genetics.integration.jei.sequencer.SequencerRecipeCategory;
import binnie.genetics.integration.jei.sequencer.SequencerRecipeMaker;
import binnie.genetics.item.ModuleItems;
import binnie.genetics.machine.AdvGeneticMachine;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.LaboratoryMachine;
import binnie.genetics.machine.incubator.Incubator;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class GeneticsJeiPlugin
extends BlankModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    public static Drawables drawables;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        ModuleItems items = Genetics.items();
        List<Item> chargeables = Arrays.asList(items.itemSequencer, items.itemSerum, items.itemSerumArray);
        ChargeableSubtypeInterpreter chargeableSubtypeInterpreter = new ChargeableSubtypeInterpreter();
        for (Item chargeable : chargeables) {
            subtypeRegistry.registerSubtypeInterpreter(chargeable, (ISubtypeRegistry.ISubtypeInterpreter)chargeableSubtypeInterpreter);
        }
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        drawables = Drawables.getDrawables(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{new IncubatorRecipeCategory(), new LarvaeIncubatorRecipeCategory(), new IsolatorRecipeCategory(), new PolymeriserRecipeCategory(), new SequencerRecipeCategory(), new InoculatorRecipeCategory(), new SplicerRecipeCategory(), new GenepoolRecipeCategory(), new DatabaseRecipeCategory()});
        registry.addRecipeCategoryCraftingItem(LaboratoryMachine.Incubator.get(1), new String[]{"binnie.genetics.incubator", "binnie.genetics.incubator.bees"});
        registry.addRecipeCategoryCraftingItem(GeneticMachine.Isolator.get(1), new String[]{"binnie.genetics.isolator"});
        registry.addRecipeCategoryCraftingItem(GeneticMachine.Polymeriser.get(1), new String[]{"binnie.genetics.polymeriser"});
        registry.addRecipeCategoryCraftingItem(GeneticMachine.Sequencer.get(1), new String[]{"binnie.genetics.sequencer"});
        registry.addRecipeCategoryCraftingItem(GeneticMachine.Inoculator.get(1), new String[]{"binnie.genetics.inoculator"});
        registry.addRecipeCategoryCraftingItem(AdvGeneticMachine.Splicer.get(1), new String[]{"binnie.genetics.splicer"});
        registry.addRecipeCategoryCraftingItem(LaboratoryMachine.Genepool.get(1), new String[]{"binnie.genetics.genepool"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)Genetics.items().database), new String[]{"binnie.genetics.database"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Item)Genetics.items().database, 1, 1), new String[]{"binnie.genetics.database"});
        registry.addRecipes(Incubator.getRecipes(), "binnie.genetics.incubator");
        registry.addRecipes(LarvaeIncubatorRecipeMaker.create(Incubator.getLarvaeRecipe()), "binnie.genetics.incubator");
        registry.addRecipes(IsolatorRecipeMaker.create(), "binnie.genetics.isolator");
        registry.addRecipes(PolymeriserRecipeMaker.create(), "binnie.genetics.polymeriser");
        registry.addRecipes(SequencerRecipeMaker.create(), "binnie.genetics.sequencer");
        registry.addRecipes(InoculatorRecipeMaker.create(), "binnie.genetics.inoculator");
        registry.addRecipes(GenepoolRecipeMaker.create(), "binnie.genetics.genepool");
        registry.addRecipes(DatabaseRecipeMaker.create(), "binnie.genetics.database");
        registry.handleRecipes(IIncubatorRecipe.class, IncubatorRecipeWrapper::new, "binnie.genetics.incubator");
    }

    private static class ChargeableSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private ChargeableSubtypeInterpreter() {
        }

        @Nullable
        public String getSubtypeInfo(ItemStack itemStack) {
            Item item = itemStack.func_77973_b();
            if (item instanceof IItemChargeable) {
                IItemChargeable itemChargeable = (IItemChargeable)item;
                boolean fullyCharged = itemChargeable.getCharges(itemStack) == itemChargeable.getMaxCharges(itemStack);
                String info = fullyCharged ? "charged" : "uncharged";
                ISpeciesRoot root = itemChargeable.getSpeciesRoot(itemStack);
                if (root != null) {
                    return info + ":" + root.getUID();
                }
            }
            return null;
        }
    }
}

