/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.genetics.BreedingSystem;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.genetics.gui.analyst.WindowAnalyst;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlSystemButton
extends Control {
    BreedingSystem system;
    WindowAnalyst window;

    public ControlSystemButton(int xPos, int yPos, WindowAnalyst window, BreedingSystem system) {
        super(window, xPos, yPos, 20, 20);
        this.system = system;
        this.window = window;
    }

    @Override
    public void initialise() {
        this.addAttribute(Attribute.MOUSE_OVER);
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onEvent(EventMouse.Down event) {
                ControlSystemButton.this.window.setSystem(ControlSystemButton.this.system);
            }
        });
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(this.system.getName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.setColour(this.system.getColour());
        int outset = this.window.getSystem() == this.system ? 1 : 0;
        CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_OUTLINE, this.getArea().outset(outset));
        if (this.window.getSystem() == this.system) {
            RenderUtil.setColour(0x44000000 + this.system.getColour());
            CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_SOLID, this.getArea().outset(outset));
        }
        RenderUtil.drawItem(new Point(2, 2), this.system.getItemStackRepresentitive());
    }
}

