/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.Binnie;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IButterfly;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageBehaviour
extends ControlAnalystPage {
    public AnalystPageBehaviour(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        this.setColor(0x660033);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (ind instanceof IBee) {
            IBee bee = (IBee)ind;
            int fertility = bee.getGenome().getFlowering();
            new ControlTextCentered((IWidget)this, y += 8, I18N.localise("genetics.gui.analyst.behaviour.pollinatesNearby") + "\n" + bee.getGenome().getFlowerProvider().getDescription()).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, I18N.localise("genetics.gui.analyst.behaviour.everyTime", this.getTimeString(55000 / fertility))).setColor(this.getColor());
            y += 22;
            IAlleleBeeEffect effect = bee.getGenome().getEffect();
            Vec3i t = bee.getGenome().getTerritory();
            if (!effect.getUID().contains("None")) {
                String effectDesc = I18N.localiseOrBlank("binniecore.allele." + effect.getUID() + ".desc");
                String loc = effectDesc.isEmpty() ? I18N.localise("genetics.gui.analyst.behaviour.effect", effect.getAlleleName()) : effectDesc;
                new ControlText(this, new Area(4, y, this.getWidth() - 8, 0), loc, TextJustification.TOP_CENTER).setColor(this.getColor());
                new ControlTextCentered((IWidget)this, y += (int)((float)CraftGUI.RENDER.textHeight(loc, this.getWidth() - 8) + 1.0f), I18N.localise("genetics.gui.analyst.behaviour.withinBlocks", (int)((float)t.func_177958_n() / 2.0f))).setColor(this.getColor());
                y += 22;
            }
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.behaviour.territory", t.func_177958_n(), t.func_177956_o(), t.func_177952_p())).setColor(this.getColor());
            y += 22;
        }
        if (ind instanceof IButterfly) {
            IButterfly bee2 = (IButterfly)ind;
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.behaviour.metabolism", Binnie.GENETICS.mothBreedingSystem.getAlleleName((IChromosomeType)EnumButterflyChromosome.METABOLISM, ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.METABOLISM)))).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, I18N.localise("genetics.gui.analyst.behaviour.pollinatesNearby") + "\n" + bee2.getGenome().getFlowerProvider().getDescription()).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, I18N.localise("genetics.gui.analyst.behaviour.everyTime", this.getTimeString(1500))).setColor(this.getColor());
            y += 22;
            IAlleleButterflyEffect effect2 = bee2.getGenome().getEffect();
            if (!effect2.getUID().contains("None")) {
                String effectDesc2 = I18N.localiseOrBlank("binniecore.allele." + effect2.getUID() + ".desc");
                String loc2 = effectDesc2.isEmpty() ? I18N.localise("genetics.gui.analyst.behaviour.effect", effect2.getAlleleName()) : effectDesc2;
                new ControlText(this, new Area(4, y, this.getWidth() - 8, 0), loc2, TextJustification.TOP_CENTER).setColor(this.getColor());
            }
        }
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.behaviour");
    }
}

