/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.api.IGene;
import binnie.genetics.genetics.IGeneItem;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GeneArrayItem
implements INbtReadable,
INbtWritable,
IGeneItem {
    private static final String GENES_NBT = "genes";
    private List<IGene> genes = new ArrayList<IGene>();

    public GeneArrayItem(ItemStack stack) {
        this.readFromNBT(stack.func_77978_p());
    }

    public GeneArrayItem(IGene gene) {
        this.addGene(gene);
    }

    public GeneArrayItem() {
    }

    @Override
    public int getColor(int renderPass) {
        BreedingSystem breedingSystem;
        if (renderPass == 2 && (breedingSystem = this.getBreedingSystem()) != null) {
            return breedingSystem.getColour();
        }
        return 0xFFFFFF;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getInfo(List<String> list) {
        ArrayList<String> totalList = new ArrayList<String>();
        BreedingSystem breedingSystem = this.getBreedingSystem();
        if (breedingSystem != null) {
            for (IGene gene : this.genes) {
                String chromosomeName = breedingSystem.getChromosomeName(gene.getChromosome());
                totalList.add(TextFormatting.GOLD + chromosomeName + TextFormatting.GRAY + ": " + gene.getName());
            }
        }
        if (totalList.size() < 4 || GuiScreen.func_146272_n()) {
            list.addAll(totalList);
        } else {
            list.add((String)totalList.get(0));
            list.add((String)totalList.get(1));
            list.add(totalList.size() - 2 + " " + I18N.localise("genetics.item.gene.more.genes"));
        }
    }

    @Nullable
    public BreedingSystem getBreedingSystem() {
        if (this.genes.size() == 0) {
            return null;
        }
        BreedingSystem system = Binnie.GENETICS.getSystem(this.genes.get(0).getSpeciesRoot().getUID());
        return system == null ? Binnie.GENETICS.getActiveSystems().iterator().next() : system;
    }

    public List<IGene> getGenes() {
        return this.genes;
    }

    public void readFromNBT(@Nullable NBTTagCompound nbt) {
        this.genes.clear();
        if (nbt == null) {
            return;
        }
        NBTTagList list = nbt.func_150295_c(GENES_NBT, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Gene gene = Gene.create(list.func_150305_b(i));
            this.genes.add(gene);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.genes.size() == 0) {
            return nbt;
        }
        NBTTagList list = new NBTTagList();
        for (IGene gene : this.genes) {
            list.func_74742_a((NBTBase)gene.getNBTTagCompound());
        }
        nbt.func_74782_a(GENES_NBT, (NBTBase)list);
        return nbt;
    }

    @Override
    @Nullable
    public ISpeciesRoot getSpeciesRoot() {
        if (this.genes.size() == 0) {
            return null;
        }
        return this.genes.get(0).getSpeciesRoot();
    }

    @Nullable
    public IGene getGene(int chromosome) {
        for (IGene gene : this.genes) {
            if (gene.getChromosome().ordinal() != chromosome) continue;
            return gene;
        }
        return null;
    }

    @Override
    public void writeToItem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        this.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    @Override
    public void addGene(IGene gene) {
        if (this.getGene(gene.getChromosome().ordinal()) != null) {
            this.genes.remove(this.getGene(gene.getChromosome().ordinal()));
        }
        this.genes.add(gene);
    }
}

