/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import binnie.Binnie;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.FruitPod;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.genetics.ETFruitFamily;
import binnie.extratrees.genetics.FruitSprite;
import binnie.extratrees.item.Food;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.genetics.alleles.AlleleTreeSpecies;
import forestry.core.genetics.alleles.AlleleCategorized;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AlleleETFruit
extends AlleleCategorized
implements IAlleleFruit,
IFruitProvider {
    public static final AlleleETFruit Blackthorn = new AlleleETFruit("Blackthorn", 10, 7180062, 14561129, FruitSprite.SMALL);
    public static final AlleleETFruit CherryPlum = new AlleleETFruit("CherryPlum", 10, 7180062, 15211595, FruitSprite.SMALL);
    public static final AlleleETFruit Peach = new AlleleETFruit("Peach", 10, 7180062, 16424995, FruitSprite.AVERAGE);
    public static final AlleleETFruit Nectarine = new AlleleETFruit("Nectarine", 10, 7180062, 16405795, FruitSprite.AVERAGE);
    public static final AlleleETFruit Apricot = new AlleleETFruit("Apricot", 10, 7180062, 16437027, FruitSprite.AVERAGE);
    public static final AlleleETFruit Almond = new AlleleETFruit("Almond", 10, 7180062, 9364342, FruitSprite.SMALL);
    public static final AlleleETFruit WildCherry = new AlleleETFruit("WildCherry", 10, 7180062, 0xFF0000, FruitSprite.TINY);
    public static final AlleleETFruit SourCherry = new AlleleETFruit("SourCherry", 10, 7180062, 10225963, FruitSprite.TINY);
    public static final AlleleETFruit BlackCherry = new AlleleETFruit("BlackCherry", 10, 7180062, 4852249, FruitSprite.TINY);
    public static final AlleleETFruit Orange = new AlleleETFruit("Orange", 10, 3665987, 16749578, FruitSprite.AVERAGE);
    public static final AlleleETFruit Manderin = new AlleleETFruit("Manderin", 10, 3665987, 16749578, FruitSprite.AVERAGE);
    public static final AlleleETFruit Tangerine = new AlleleETFruit("Tangerine", 10, 3665987, 16749578, FruitSprite.AVERAGE);
    public static final AlleleETFruit Satsuma = new AlleleETFruit("Satsuma", 10, 3665987, 16749578, FruitSprite.AVERAGE);
    public static final AlleleETFruit KeyLime = new AlleleETFruit("KeyLime", 10, 3665987, 10223428, FruitSprite.SMALL);
    public static final AlleleETFruit Lime = new AlleleETFruit("Lime", 10, 3665987, 10223428, FruitSprite.AVERAGE);
    public static final AlleleETFruit FingerLime = new AlleleETFruit("FingerLime", 10, 3665987, 11156280, FruitSprite.SMALL);
    public static final AlleleETFruit Pomelo = new AlleleETFruit("Pomelo", 10, 3665987, 6083402, FruitSprite.LARGER);
    public static final AlleleETFruit Grapefruit = new AlleleETFruit("Grapefruit", 10, 3665987, 16749578, FruitSprite.LARGE);
    public static final AlleleETFruit Kumquat = new AlleleETFruit("Kumquat", 10, 3665987, 16749578, FruitSprite.SMALL);
    public static final AlleleETFruit Citron = new AlleleETFruit("Citron", 10, 3665987, 16772192, FruitSprite.LARGE);
    public static final AlleleETFruit BuddhaHand = new AlleleETFruit("BuddhaHand", 10, 3665987, 16772192, FruitSprite.LARGE);
    public static final AlleleETFruit Apple = new AlleleETFruit("Apple", 10, 7915859, 16193046, FruitSprite.AVERAGE);
    public static final AlleleETFruit Crabapple = new AlleleETFruit("Crabapple", 10, 7915859, 16760140, FruitSprite.AVERAGE);
    public static final AlleleETFruit Banana = new AlleleETFruit("Banana", FruitPod.Banana);
    public static final AlleleETFruit RedBanana = new AlleleETFruit("Red Banana", FruitPod.RedBanana);
    public static final AlleleETFruit Plantain = new AlleleETFruit("Platain", FruitPod.Plantain);
    public static final AlleleETFruit Hazelnut = new AlleleETFruit("Hazelnut", 7, 8223006, 14463606, FruitSprite.SMALL);
    public static final AlleleETFruit Butternut = new AlleleETFruit("Butternut", 7, 11712336, 16102498, FruitSprite.SMALL);
    public static final AlleleETFruit Beechnut = new AlleleETFruit("Beechnut", 8, 14401148, 6241845, FruitSprite.TINY);
    public static final AlleleETFruit Pecan = new AlleleETFruit("Pecan", 8, 10660940, 15781769, FruitSprite.SMALL);
    public static final AlleleETFruit BrazilNut = new AlleleETFruit("BrazilNut", 10, 5875561, 9852208, FruitSprite.LARGE);
    public static final AlleleETFruit Fig = new AlleleETFruit("Fig", 9, 14201186, 7094086, FruitSprite.SMALL);
    public static final AlleleETFruit Acorn = new AlleleETFruit("Acorn", 6, 7516710, 11364893, FruitSprite.TINY);
    public static final AlleleETFruit Elderberry = new AlleleETFruit("Elderberry", 9, 7444317, 5331779, FruitSprite.TINY);
    public static final AlleleETFruit Olive = new AlleleETFruit("Olive", 9, 8887861, 6444842, FruitSprite.SMALL);
    public static final AlleleETFruit GingkoNut = new AlleleETFruit("GingkoNut", 7, 9213787, 15063725, FruitSprite.TINY);
    public static final AlleleETFruit Coffee = new AlleleETFruit("Coffee", 8, 7433501, 16273254, FruitSprite.TINY);
    public static final AlleleETFruit Pear = new AlleleETFruit("Pear", 10, 10456913, 10474833, FruitSprite.PEAR);
    public static final AlleleETFruit OsangeOsange = new AlleleETFruit("OsangeOsange", 10, 9934674, 10665767, FruitSprite.LARGER);
    public static final AlleleETFruit Clove = new AlleleETFruit("Clove", 9, 6847532, 11224133, FruitSprite.TINY);
    public static final AlleleETFruit Coconut = new AlleleETFruit("Coconut", FruitPod.Coconut);
    public static final AlleleETFruit Cashew = new AlleleETFruit("Cashew", 8, 12879132, 15289111, FruitSprite.AVERAGE);
    public static final AlleleETFruit Avacado = new AlleleETFruit("Avacado", 10, 10272370, 2170640, FruitSprite.PEAR);
    public static final AlleleETFruit Nutmeg = new AlleleETFruit("Nutmeg", 9, 14861101, 11305813, FruitSprite.TINY);
    public static final AlleleETFruit Allspice = new AlleleETFruit("Allspice", 9, 15180922, 7423542, FruitSprite.TINY);
    public static final AlleleETFruit Chilli = new AlleleETFruit("Chilli", 10, 7430757, 15145010, FruitSprite.SMALL);
    public static final AlleleETFruit StarAnise = new AlleleETFruit("StarAnise", 8, 8733742, 13917189, FruitSprite.TINY);
    public static final AlleleETFruit Mango = new AlleleETFruit("Mango", 10, 6654997, 15902262, FruitSprite.AVERAGE);
    public static final AlleleETFruit Starfruit = new AlleleETFruit("Starfruit", 10, 9814541, 15061550, FruitSprite.AVERAGE);
    public static final AlleleETFruit Candlenut = new AlleleETFruit("Candlenut", 8, 8235123, 14600882, FruitSprite.SMALL);
    public static final AlleleETFruit Papayimar = new AlleleETFruit("Papayimar", FruitPod.Papayimar);
    public static final AlleleETFruit Blackcurrant = new AlleleETFruit("Blackcurrant", 8, 9407571, 4935251, FruitSprite.TINY);
    public static final AlleleETFruit Redcurrant = new AlleleETFruit("Redcurrant", 8, 13008910, 15080974, FruitSprite.TINY);
    public static final AlleleETFruit Blackberry = new AlleleETFruit("Blackberry", 8, 9399665, 4801393, FruitSprite.TINY);
    public static final AlleleETFruit Raspberry = new AlleleETFruit("Raspberry", 8, 15520197, 14510449, FruitSprite.TINY);
    public static final AlleleETFruit Blueberry = new AlleleETFruit("Blueberry", 8, 10203799, 6329278, FruitSprite.TINY);
    public static final AlleleETFruit Cranberry = new AlleleETFruit("Cranberry", 8, 12232496, 14555696, FruitSprite.TINY);
    public static final AlleleETFruit Juniper = new AlleleETFruit("Juniper", 8, 10194034, 6316914, FruitSprite.TINY);
    public static final AlleleETFruit Gooseberry = new AlleleETFruit("Gooseberry", 8, 12164944, 12177232, FruitSprite.TINY);
    public static final AlleleETFruit GoldenRaspberry = new AlleleETFruit("GoldenRaspberry", 8, 12496955, 15970363, FruitSprite.TINY);
    @Nullable
    private static LinkedList<AlleleETFruit> list;
    @Nullable
    private IFruitFamily family;
    private boolean isRipening = false;
    private int diffR;
    private int diffG;
    private int diffB = 0;
    @Nullable
    private FruitPod pod;
    private int ripeningPeriod;
    private int colourUnripe;
    private int colour;
    @Nullable
    private FruitSprite sprite;
    private Map<ItemStack, Float> products;

    private AlleleETFruit(String name, int time, int unripe, int colour, FruitSprite sprite) {
        super("extratrees", "fruit", name, true);
        this.pod = null;
        this.ripeningPeriod = 0;
        this.products = new HashMap<ItemStack, Float>();
        this.colour = colour;
        this.sprite = sprite;
        this.setRipening(time, unripe);
    }

    private AlleleETFruit(String name, FruitPod pod) {
        super("extratrees", "fruit", name, true);
        this.sprite = null;
        this.products = new HashMap<ItemStack, Float>();
        this.pod = pod;
        this.ripeningPeriod = 2;
    }

    public static List<AlleleETFruit> values() {
        if (list == null) {
            list = new LinkedList();
            for (Field f : AlleleETFruit.class.getFields()) {
                if (f.getType() != AlleleETFruit.class) continue;
                try {
                    list.add((AlleleETFruit)((Object)f.get((Object)Acorn)));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static void preInit() {
        for (AlleleETFruit fruit : AlleleETFruit.values()) {
            AlleleManager.alleleRegistry.registerAllele((IAllele)fruit, new IChromosomeType[]{EnumTreeChromosome.FRUITS});
        }
    }

    public static void init() {
        IFruitFamily familyPrune = AlleleManager.alleleRegistry.getFruitFamily("forestry.prunes");
        IFruitFamily familyPome = AlleleManager.alleleRegistry.getFruitFamily("forestry.pomes");
        IFruitFamily familyJungle = AlleleManager.alleleRegistry.getFruitFamily("forestry.jungle");
        IFruitFamily familyNuts = AlleleManager.alleleRegistry.getFruitFamily("forestry.nuts");
        ETFruitFamily familyBerry = ETFruitFamily.Berry;
        ETFruitFamily familyCitrus = ETFruitFamily.Citrus;
        AlleleManager.alleleRegistry.registerFruitFamily((IFruitFamily)familyBerry);
        AlleleManager.alleleRegistry.registerFruitFamily((IFruitFamily)familyCitrus);
        Apple.addProduct(new ItemStack(Items.field_151034_e), 1.0f);
        Apple.setFamily(familyPome);
        Crabapple.addProduct(Food.CRABAPPLE.get(1), 1.0f);
        Crabapple.setFamily(familyPome);
        Orange.addProduct(Food.ORANGE.get(1), 1.0f);
        Orange.setFamily(familyCitrus);
        Manderin.addProduct(Food.MANDERIN.get(1), 1.0f);
        Manderin.setFamily(familyCitrus);
        Tangerine.addProduct(Food.TANGERINE.get(1), 1.0f);
        Tangerine.setFamily(familyCitrus);
        Satsuma.addProduct(Food.SATSUMA.get(1), 1.0f);
        Satsuma.setFamily(familyCitrus);
        KeyLime.addProduct(Food.KEY_LIME.get(1), 1.0f);
        KeyLime.setFamily(familyCitrus);
        Lime.addProduct(Food.LIME.get(1), 1.0f);
        Lime.setFamily(familyCitrus);
        FingerLime.addProduct(Food.FINGER_LIME.get(1), 1.0f);
        FingerLime.setFamily(familyCitrus);
        Pomelo.addProduct(Food.POMELO.get(1), 1.0f);
        Pomelo.setFamily(familyCitrus);
        Grapefruit.addProduct(Food.GRAPEFRUIT.get(1), 1.0f);
        Grapefruit.setFamily(familyCitrus);
        Kumquat.addProduct(Food.KUMQUAT.get(1), 1.0f);
        Kumquat.setFamily(familyCitrus);
        Citron.addProduct(Food.CITRON.get(1), 1.0f);
        Citron.setFamily(familyCitrus);
        BuddhaHand.addProduct(Food.BUDDHA_HAND.get(1), 1.0f);
        BuddhaHand.setFamily(familyCitrus);
        Blackthorn.addProduct(Food.Blackthorn.get(1), 1.0f);
        Blackthorn.setFamily(familyPrune);
        CherryPlum.addProduct(Food.CHERRY_PLUM.get(1), 1.0f);
        CherryPlum.setFamily(familyPrune);
        Peach.addProduct(Food.PEACH.get(1), 1.0f);
        Peach.setFamily(familyPrune);
        Nectarine.addProduct(Food.NECTARINE.get(1), 1.0f);
        Nectarine.setFamily(familyPrune);
        Apricot.addProduct(Food.APRICOT.get(1), 1.0f);
        Apricot.setFamily(familyPrune);
        Almond.addProduct(Food.ALMOND.get(1), 1.0f);
        Almond.setFamily(familyPrune);
        WildCherry.addProduct(Food.WILD_CHERRY.get(1), 1.0f);
        WildCherry.setFamily(familyPrune);
        SourCherry.addProduct(Food.SOUR_CHERRY.get(1), 1.0f);
        SourCherry.setFamily(familyPrune);
        BlackCherry.addProduct(Food.BLACK_CHERRY.get(1), 1.0f);
        BlackCherry.setFamily(familyPrune);
        Hazelnut.addProduct(Food.HAZELNUT.get(1), 1.0f);
        Hazelnut.setFamily(familyNuts);
        Butternut.addProduct(Food.BUTTERNUT.get(1), 1.0f);
        Butternut.setFamily(familyNuts);
        Beechnut.addProduct(Food.BEECHNUT.get(1), 1.0f);
        Beechnut.setFamily(familyNuts);
        Pecan.addProduct(Food.PECAN.get(1), 1.0f);
        Pecan.setFamily(familyNuts);
        Banana.addProduct(Food.BANANA.get(2), 1.0f);
        Banana.setFamily(familyJungle);
        RedBanana.addProduct(Food.RED_BANANA.get(2), 1.0f);
        RedBanana.setFamily(familyJungle);
        Plantain.addProduct(Food.PLANTAIN.get(2), 1.0f);
        Plantain.setFamily(familyJungle);
        BrazilNut.addProduct(Food.BRAZIL_NUT.get(4), 1.0f);
        BrazilNut.setFamily(familyNuts);
        Fig.addProduct(Food.FIG.get(1), 1.0f);
        Fig.setFamily(familyPrune);
        Acorn.addProduct(Food.ACORN.get(1), 1.0f);
        Acorn.setFamily(familyNuts);
        Elderberry.addProduct(Food.ELDERBERRY.get(1), 1.0f);
        Elderberry.setFamily(familyPrune);
        Olive.addProduct(Food.OLIVE.get(1), 1.0f);
        Olive.setFamily(familyPrune);
        GingkoNut.addProduct(Food.GINGKO_NUT.get(1), 1.0f);
        GingkoNut.setFamily(familyNuts);
        Coffee.addProduct(Food.COFFEE.get(1), 1.0f);
        Coffee.setFamily(familyJungle);
        Pear.addProduct(Food.PEAR.get(1), 1.0f);
        Pear.setFamily(familyPome);
        OsangeOsange.addProduct(Food.OSANGE_ORANGE.get(1), 1.0f);
        OsangeOsange.setFamily(familyPome);
        Clove.addProduct(Food.CLOVE.get(1), 1.0f);
        Clove.setFamily(familyNuts);
        Blackcurrant.addProduct(Food.BLACKCURRANT.get(2), 1.0f);
        Blackcurrant.setFamily(familyBerry);
        Redcurrant.addProduct(Food.REDCURRANT.get(2), 1.0f);
        Redcurrant.setFamily(familyBerry);
        Blackberry.addProduct(Food.BLACKBERRY.get(2), 1.0f);
        Blackberry.setFamily(familyBerry);
        Raspberry.addProduct(Food.RASPBERRY.get(2), 1.0f);
        Raspberry.setFamily(familyBerry);
        Blueberry.addProduct(Food.BLUEBERRY.get(2), 1.0f);
        Blueberry.setFamily(familyBerry);
        Cranberry.addProduct(Food.CRANBERRY.get(2), 1.0f);
        Cranberry.setFamily(familyBerry);
        Juniper.addProduct(Food.JUNIPER.get(2), 1.0f);
        Juniper.setFamily(familyBerry);
        Gooseberry.addProduct(Food.GOOSEBERRY.get(2), 1.0f);
        Gooseberry.setFamily(familyBerry);
        GoldenRaspberry.addProduct(Food.GOLDEN_RASPBERRY.get(2), 1.0f);
        GoldenRaspberry.setFamily(familyBerry);
        Coconut.addProduct(Food.COCONUT.get(1), 1.0f);
        Coconut.setFamily(familyJungle);
        Cashew.addProduct(Food.CASHEW.get(1), 1.0f);
        Cashew.setFamily(familyJungle);
        Avacado.addProduct(Food.AVACADO.get(1), 1.0f);
        Avacado.setFamily(familyJungle);
        Nutmeg.addProduct(Food.NUTMEG.get(1), 1.0f);
        Nutmeg.setFamily(familyJungle);
        Allspice.addProduct(Food.ALLSPICE.get(1), 1.0f);
        Allspice.setFamily(familyJungle);
        Chilli.addProduct(Food.CHILLI.get(1), 1.0f);
        Chilli.setFamily(familyJungle);
        StarAnise.addProduct(Food.STAR_ANISE.get(1), 1.0f);
        StarAnise.setFamily(familyJungle);
        Mango.addProduct(Food.MANGO.get(1), 1.0f);
        Mango.setFamily(familyPome);
        Starfruit.addProduct(Food.STARFRUIT.get(1), 1.0f);
        Starfruit.setFamily(familyJungle);
        Candlenut.addProduct(Food.CANDLENUT.get(1), 1.0f);
        Candlenut.setFamily(familyJungle);
        if (ConfigurationMain.alterLemon) {
            try {
                IAlleleFruit lemon = (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("forestry.fruitLemon");
                FruitProviderNone prov = (FruitProviderNone)lemon.getProvider();
                Field f = FruitProviderNone.class.getDeclaredField("family");
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                f.setAccessible(true);
                modifiersField.setAccessible(true);
                modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                f.set(prov, (Object)familyCitrus);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        for (IAlleleSpecies tree : Binnie.GENETICS.treeBreedingSystem.getAllSpecies()) {
            if (!(tree instanceof AlleleTreeSpecies) || !((IAlleleTreeSpecies)tree).getSuitableFruit().contains(familyPrune)) continue;
            ((AlleleTreeSpecies)tree).addFruitFamily((IFruitFamily)familyCitrus);
        }
    }

    public void setRipening(int time, int unripe) {
        this.ripeningPeriod = time;
        this.colourUnripe = unripe;
        this.isRipening = true;
        this.diffR = (this.colour >> 16 & 0xFF) - (unripe >> 16 & 0xFF);
        this.diffG = (this.colour >> 8 & 0xFF) - (unripe >> 8 & 0xFF);
        this.diffB = (this.colour & 0xFF) - (unripe & 0xFF);
    }

    public void addProduct(ItemStack product, float chance) {
        this.products.put(product, Float.valueOf(chance));
    }

    public IFruitProvider getProvider() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        if (this == Apple) {
            for (FruitSprite sprite : FruitSprite.VALUES) {
                sprite.registerSprites();
            }
        }
    }

    @Nullable
    public ResourceLocation getSprite(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        if (this.sprite != null) {
            return this.sprite.getLocation();
        }
        return null;
    }

    public int compareTo(IAlleleFruit o) {
        return o == this ? 0 : -1;
    }

    public Map<ItemStack, Float> getSpecialty() {
        return new HashMap<ItemStack, Float>();
    }

    public int getDecorativeColor() {
        return this.getColour(1.0f);
    }

    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, Random rand, BlockPos pos) {
        return this.pod != null && world.field_73012_v.nextFloat() <= genome.getSappiness() && TreeManager.treeRoot.setFruitBlock(world, genome, (IAlleleFruit)this, genome.getSappiness(), pos);
    }

    public NonNullList<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        NonNullList products;
        block5: {
            block4: {
                products = NonNullList.func_191196_a();
                if (this.pod == null) break block4;
                if (ripeningTime < 2) break block5;
                for (Map.Entry<ItemStack, Float> product : this.products.entrySet()) {
                    ItemStack single = product.getKey().func_77946_l();
                    single.func_190920_e(1);
                    for (int i = 0; i < product.getKey().func_190916_E(); ++i) {
                        if (!(world.field_73012_v.nextFloat() <= product.getValue().floatValue())) continue;
                        products.add((Object)single.func_77946_l());
                    }
                }
                break block5;
            }
            float stage = this.getRipeningStage(ripeningTime);
            if (stage >= 0.5f) {
                float modeYieldMod = 1.0f;
                for (Map.Entry<ItemStack, Float> product : this.products.entrySet()) {
                    if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * product.getValue().floatValue() * 5.0f * stage)) continue;
                    products.add((Object)product.getKey().func_77946_l());
                }
            }
        }
        return products;
    }

    @Nullable
    public String getModelName() {
        if (this.pod != null) {
            return this.pod.getModelName();
        }
        return null;
    }

    public boolean isFruitLeaf(ITreeGenome genome, World world, BlockPos pos) {
        return this.sprite != null;
    }

    public String getModID() {
        return "extratrees";
    }

    public int getColour(ITreeGenome genome, IBlockAccess world, BlockPos pos, int ripeningTime) {
        if (!this.isRipening) {
            return this.colour;
        }
        float stage = this.getRipeningStage(ripeningTime);
        return this.getColour(stage);
    }

    private int getColour(float stage) {
        int r = (this.colourUnripe >> 16 & 0xFF) + (int)((float)this.diffR * stage);
        int g = (this.colourUnripe >> 8 & 0xFF) + (int)((float)this.diffG * stage);
        int b = (this.colourUnripe & 0xFF) + (int)((float)this.diffB * stage);
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public String getDescription() {
        return I18N.localise("extratrees.item.food." + ((Object)((Object)this)).getClass().getTypeName().toLowerCase());
    }

    public IFruitFamily getFamily() {
        Preconditions.checkState((this.family != null ? 1 : 0) != 0, (Object)"Family has not been set.");
        return this.family;
    }

    private void setFamily(IFruitFamily family) {
        this.family = family;
    }

    public int getRipeningPeriod() {
        return this.ripeningPeriod;
    }

    public Map<ItemStack, Float> getProducts() {
        return this.products;
    }

    private float getRipeningStage(int ripeningTime) {
        if (ripeningTime >= this.ripeningPeriod) {
            return 1.0f;
        }
        return ripeningTime / this.ripeningPeriod;
    }

    public boolean requiresFruitBlocks() {
        return this.pod != null;
    }

    @Nullable
    public ResourceLocation getDecorativeSprite() {
        if (this.sprite != null) {
            return this.sprite.getLocation();
        }
        return null;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getNameOfFruit() {
        if (this == Apple) {
            return "Apple";
        }
        for (ItemStack stack : this.products.keySet()) {
            if (stack.func_77973_b() != ExtraTrees.items().itemFood) continue;
            return Food.values()[stack.func_77952_i()].toString();
        }
        return "NoFruit";
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }
}

