/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.proxy;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.IItemModelProvider;
import binnie.extrabees.proxy.ExtraBeesCommonProxy;
import binnie.extrabees.utils.ExtraBeesResourceLocation;
import com.google.common.collect.ImmutableList;
import forestry.core.models.BlankModel;
import forestry.core.models.ModelManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExtraBeesClientProxy
extends ExtraBeesCommonProxy {
    private static final ModelManager modelManager = ModelManager.getInstance();

    private static IBakedModel bakeModelFor(final Block block) {
        return new BlankModel(){

            protected ItemOverrideList createOverrides() {
                return new ItemOverrideList((List)ImmutableList.of()){

                    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(block.func_176203_a(stack.func_77960_j()));
                    }
                };
            }
        };
    }

    @Override
    public Item registerItem(Item item) {
        modelManager.registerItemClient(item);
        if (item instanceof IItemModelProvider) {
            ((IItemModelProvider)item).registerModel(item);
        }
        return super.registerItem(item);
    }

    @Override
    public Block registerBlock(Block block) {
        modelManager.registerBlockClient(block);
        return super.registerBlock(block);
    }

    @Override
    public void registerModel(@Nonnull Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    public void onModelsBaked(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        this.registerItemBlockLink(new ExtraBeesResourceLocation("alveary"), ExtraBees.alveary, (IRegistry<ModelResourceLocation, IBakedModel>)registry);
        this.registerItemBlockLink(new ExtraBeesResourceLocation("ectoplasm"), ExtraBees.ectoplasm, (IRegistry<ModelResourceLocation, IBakedModel>)registry);
        this.registerItemBlockLink(new ExtraBeesResourceLocation("hive"), ExtraBees.hive, (IRegistry<ModelResourceLocation, IBakedModel>)registry);
    }

    private void registerItemBlockLink(ResourceLocation item, Block block, IRegistry<ModelResourceLocation, IBakedModel> registry) {
        registry.func_82595_a((Object)new ModelResourceLocation(item, "inventory"), (Object)ExtraBeesClientProxy.bakeModelFor(block));
    }
}

