/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.types.IEBEnumItem;
import binnie.extrabees.utils.Utils;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public enum EnumHoneyDrop implements IEBEnumItem
{
    ENERGY(10242418, 14905713, ""),
    ACID(4961601, 4841020, "acid"),
    POISON(13698745, 16712674, "poison"),
    APPLE(13062738, 13183530, "juice"),
    CITRUS,
    ICE(11462882, 9895925, "liquidnitrogen"),
    MILK(0xE0E0E0, 0xFFFFFF, "milk"),
    SEED(0x7CC272, 12762791, "seedoil"),
    ALCOHOL(14411853, 10872909, "short.mead"),
    FRUIT,
    VEGETABLE,
    PUMPKIN,
    MELON,
    RED(0xCC4C4C, 0xFF0000, "for.honey"),
    YELLOW(0xE5E533, 0xFFDD00, "for.honey"),
    BLUE(10072818, 8959, "for.honey"),
    GREEN(6717235, 39168, "for.honey"),
    BLACK(0x191919, 0x575757, "for.honey"),
    WHITE(0xD6D6D6, 0xFFFFFF, "for.honey"),
    BROWN(8349260, 6042895, "for.honey"),
    ORANGE(15905331, 16751872, "for.honey"),
    CYAN(5020082, 65509, "for.honey"),
    PURPLE(11691749, 11403519, "for.honey"),
    GRAY(0x4C4C4C, 0xBABABA, "for.honey"),
    LIGHTBLUE(10072818, 40447, "for.honey"),
    PINK(15905484, 16744671, "for.honey"),
    LIMEGREEN(8375321, 65288, "for.honey"),
    MAGENTA(15040472, 0xFF00CC, "for.honey"),
    LIGHTGRAY(0x999999, 0xC9C9C9, "for.honey");

    private int[] colour;
    private String liquidName;
    private ItemStack remnant = ItemStack.field_190927_a;

    private EnumHoneyDrop() {
        this(0xFFFFFF, 0xFFFFFF, "");
    }

    private EnumHoneyDrop(int colour, int colour2, String liquid) {
        this.colour = new int[]{colour, colour2};
        this.liquidName = liquid;
    }

    public static EnumHoneyDrop get(ItemStack itemStack) {
        int i = itemStack.func_77952_i();
        if (i >= 0 && i < EnumHoneyDrop.values().length) {
            return EnumHoneyDrop.values()[i];
        }
        return EnumHoneyDrop.values()[0];
    }

    public void addRemnant(ItemStack stack) {
        this.remnant = stack;
    }

    public void addRecipe() {
        FluidStack liquid = Utils.getFluidFromName(this.getLiquidName(), 200);
        if (liquid != null) {
            RecipeManagers.squeezerManager.addRecipe(10, this.get(1), liquid, this.getRemnant(), 100);
        }
    }

    @Override
    public boolean isActive() {
        return !this.remnant.func_190926_b() && FluidRegistry.isFluidRegistered((String)this.getLiquidName());
    }

    @Override
    public ItemStack get(int size) {
        return new ItemStack(ExtraBees.honeyDrop, size, this.ordinal());
    }

    @Override
    public String getName(ItemStack stack) {
        return I18N.localise("extrabees.item.honeydrop." + this.name().toLowerCase());
    }

    public int[] getColour() {
        return this.colour;
    }

    public String getLiquidName() {
        return this.liquidName;
    }

    public ItemStack getRemnant() {
        return this.remnant;
    }
}

