/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import binnie.core.util.I18N;
import binnie.extrabees.items.ItemHiveFrame;
import binnie.extrabees.utils.BeeModifierLogic;
import binnie.extrabees.utils.EnumBeeBooleanModifier;
import binnie.extrabees.utils.EnumBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.PluginApiculture;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumHiveFrame implements IHiveFrame,
IBeeModifier
{
    COCOA{

        @Override
        protected void init(ItemStack impregnatedFrame) {
            this.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.25f);
            this.logic.setModifier(EnumBeeModifier.PRODUCTION, 1.5f, 5.0f);
            GameRegistry.addRecipe((ItemStack)new ItemStack(COCOA.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), impregnatedFrame, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 3)});
        }
    }
    ,
    CAGE{

        @Override
        protected void init(ItemStack impregnatedFrame) {
            this.logic.setModifier(EnumBeeModifier.TERRITORY, 0.5f, 0.1f);
            this.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.5f);
            this.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.75f, 0.5f);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(CAGE.item), (Object[])new Object[]{impregnatedFrame, Blocks.field_150411_aY});
        }
    }
    ,
    SOUL(80){

        @Override
        protected void init(ItemStack impregnatedFrame) {
            this.logic.setModifier(EnumBeeModifier.MUTATION, 1.5f, 5.0f);
            this.logic.setModifier(EnumBeeModifier.LIFESPAN, 0.75f, 0.5f);
            this.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.25f, 0.1f);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(SOUL.item), (Object[])new Object[]{impregnatedFrame, Blocks.field_150425_aM});
        }
    }
    ,
    CLAY{

        @Override
        protected void init(ItemStack impregnatedFrame) {
            this.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.5f, 5.0f);
            this.logic.setModifier(EnumBeeModifier.MUTATION, 0.5f, 0.2f);
            this.logic.setModifier(EnumBeeModifier.PRODUCTION, 0.75f, 0.2f);
            GameRegistry.addRecipe((ItemStack)new ItemStack(CLAY.item), (Object[])new Object[]{" c ", "cFc", " c ", Character.valueOf('F'), impregnatedFrame, Character.valueOf('c'), Items.field_151119_aD});
        }
    }
    ,
    DEBUG{

        @Override
        protected void init(ItemStack impregnatedFrame) {
            this.logic.setModifier(EnumBeeModifier.LIFESPAN, 1.0E-4f, 1.0E-4f);
        }
    };

    private final Item item;
    private final int maxDamage;
    protected final BeeModifierLogic logic;

    private EnumHiveFrame() {
        this(240);
    }

    private EnumHiveFrame(int maxDamage) {
        this.maxDamage = maxDamage;
        this.logic = new BeeModifierLogic();
        this.item = (Item)new ItemHiveFrame(this).setRegistryName("hive_frame." + this.name().toLowerCase());
    }

    protected void init(ItemStack impregnatedFrame) {
    }

    public static void init() {
        ItemStack impregnatedFrame = PluginApiculture.getItems().frameImpregnated.getItemStack();
        for (EnumHiveFrame frame : EnumHiveFrame.values()) {
            frame.init(impregnatedFrame);
        }
    }

    public int getIconIndex() {
        return 55 + this.ordinal();
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public ItemStack frameUsed(IBeeHousing house, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77952_i() + wear);
        if (frame.func_77952_i() >= frame.func_77958_k()) {
            return ItemStack.field_190927_a;
        }
        return frame;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.TERRITORY, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.MUTATION, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.LIFESPAN, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.PRODUCTION, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.FLOWERING, currentModifier);
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return this.logic.getModifier(EnumBeeModifier.GENETIC_DECAY, currentModifier);
    }

    public boolean isSealed() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Sealed);
    }

    public boolean isSelfLighted() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SelfLighted);
    }

    public boolean isSunlightSimulated() {
        return this.logic.getModifier(EnumBeeBooleanModifier.SunlightStimulated);
    }

    public boolean isHellish() {
        return this.logic.getModifier(EnumBeeBooleanModifier.Hellish);
    }

    public String getName() {
        return I18N.localise("extrabees.item.frame." + this.toString().toLowerCase());
    }

    public IBeeModifier getBeeModifier() {
        return this;
    }

    public Item getItem() {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.logic.addInformation(stack, playerIn, tooltip, advanced);
    }
}

