/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.extrabees.items.ItemHoneyComb;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleBeeSpecies;
import net.minecraft.item.ItemStack;

public class ExtraBeeSpecies
extends AlleleBeeSpecies {
    private State state = State.ACTIVE;

    public ExtraBeeSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean dominant, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, unlocalizedName, authority, unlocalizedDescription, dominant, branch, binomial, primaryColor, secondaryColor);
    }

    public IAlleleBeeSpeciesBuilder addProduct(ItemStack product, Float chance) {
        if ((product.func_190926_b() || ItemHoneyComb.isInvalidComb(product)) && this.state == State.ACTIVE) {
            this.state = State.INACTIVE;
            return this;
        }
        return super.addProduct(product, chance);
    }

    public IAlleleBeeSpeciesBuilder addSpecialty(ItemStack specialty, Float chance) {
        if ((specialty.func_190926_b() || ItemHoneyComb.isInvalidComb(specialty)) && this.state == State.ACTIVE) {
            this.state = State.INACTIVE;
            return this;
        }
        return super.addSpecialty(specialty, chance);
    }

    public IAlleleBeeSpecies build() {
        if (this.state == State.INACTIVE && this.state != State.ACTIVE) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
        return super.build();
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public static enum State {
        ACTIVE,
        INACTIVE,
        DEPRECATED;

    }
}

