/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.genetics.genetics.AlleleHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.Locale;

public enum ExtraBeeBranchDefinition implements IBranchDefinition
{
    BARREN("Vacapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.DEAD.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        }
    }
    ,
    HOSTILE("Infenapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.DEAD.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        }
    }
    ,
    ROCKY("Monapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
        }
    }
    ,
    METALLIC("Lamminapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }
    }
    ,
    METALLIC2("Metalapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }
    }
    ,
    ALLOY("Allapis"),
    PRECIOUS("Pluriapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }
    }
    ,
    MINERAL("Niphapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }
    }
    ,
    GEMSTONE("Gemmapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }
    }
    ,
    NUCLEAR("Levapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.ROCK.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.RADIOACTIVE.getUID()));
        }
    }
    ,
    HISTORIC("Priscapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }
    }
    ,
    FOSSILIZED("Fosiapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }
    }
    ,
    REFINED("Petrapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }
    }
    ,
    AQUATIC("Aquapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.WATER.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.WATER.getUID()));
        }
    }
    ,
    SACCHARINE("Sacchapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.SUGAR.getUID()));
        }
    }
    ,
    CLASSICAL("Grecapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }
    }
    ,
    VOLCANIC("Irrapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.METEOR.getUID()));
        }
    }
    ,
    VIRULENT("Virapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectMiasmic);
        }
    }
    ,
    VISCOUS("Viscapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.ECTOPLASM.getUID()));
        }
    }
    ,
    CAUSTIC("Morbapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.ACID.getUID()));
        }
    }
    ,
    ENERGETIC("Incitapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.REDSTONE.getUID()));
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.LIGHTNING.getUID()));
        }
    }
    ,
    FARMING("Agriapis"),
    SHADOW("Pullapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.BLINDNESS.getUID()));
        }
    }
    ,
    PRIMARY("Primapis"),
    SECONDARY("Secapis"),
    TERTIARY("Tertiapis"),
    FTB("Eftebeapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectBeatific);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.MAXIMUM);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.MAXIMUM);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGEST);
        }
    }
    ,
    QUANTUM("Quantapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.GRAVITY.getUID()));
        }
    }
    ,
    BOTANIA("Botaniapis"){

        @Override
        protected void setBranchProperties(IAllele[] template) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.MYSTICAL.getUID()));
        }
    };

    private static IAllele[] defaultTemplate;
    private final IClassification branch;

    private ExtraBeeBranchDefinition(String scientific) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(Locale.ENGLISH), scientific);
        IClassification parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
        if (parent != null) {
            parent.addMemberGroup(this.branch);
        }
    }

    protected void setBranchProperties(IAllele[] template) {
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = ExtraBeeBranchDefinition.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }
}

