/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.mod.config;

import binnie.core.AbstractMod;
import binnie.core.ManagerBase;
import binnie.core.mod.config.BinnieConfiguration;
import binnie.core.mod.config.BinnieItemData;
import binnie.core.mod.config.ConfigFile;
import binnie.core.mod.config.ConfigProperty;
import binnie.core.mod.config.PropertyBase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class ManagerConfig
extends ManagerBase {
    private Map<Class<?>, Configuration> configurations = new LinkedHashMap();
    private Map<AbstractMod, List<BinnieItemData>> itemIDs = new HashMap<AbstractMod, List<BinnieItemData>>();

    public void registerConfiguration(Class<?> cls, AbstractMod mod) {
        if (cls.isAnnotationPresent(ConfigFile.class)) {
            this.loadConfiguration(cls, mod);
        }
    }

    public void loadConfiguration(Class<?> cls, AbstractMod mod) {
        String filename = cls.getAnnotation(ConfigFile.class).filename();
        BinnieConfiguration config = new BinnieConfiguration(filename, mod);
        config.load();
        for (Field field : cls.getFields()) {
            if (!field.isAnnotationPresent(ConfigProperty.class)) continue;
            ConfigProperty propertyAnnot = field.getAnnotation(ConfigProperty.class);
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(ConfigProperty.Type.class)) continue;
                Class<PropertyBase<?, ?>> propertyClass = annotation.annotationType().getAnnotation(ConfigProperty.Type.class).propertyClass();
                try {
                    PropertyBase<?, ?> propertyBase = propertyClass.getConstructor(Field.class, BinnieConfiguration.class, ConfigProperty.class, annotation.annotationType()).newInstance(new Object[]{field, config, propertyAnnot, annotation.annotationType().cast(annotation)});
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        config.save();
        this.configurations.put(cls, config);
    }

    public void addItemID(Integer configValue, String configKey, BinnieConfiguration configFile) {
        if (!this.itemIDs.containsKey(configFile.mod)) {
            this.itemIDs.put(configFile.mod, new ArrayList());
        }
        this.itemIDs.get(configFile.mod).add(new BinnieItemData(configValue + 256, configFile, configKey));
    }
}

