/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlCheckbox;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.button.ControlButton;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.controls.page.ControlPages;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.geometry.CraftGUIUtil;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.Position;
import binnie.core.gui.minecraft.Dialog;
import binnie.core.gui.minecraft.EnumColor;
import binnie.core.gui.minecraft.IWindowAffectsShiftClick;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlide;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.minecraft.control.ControlSlotArray;
import binnie.core.gui.minecraft.control.ControlTabIcon;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.gui.window.Panel;
import binnie.core.machines.Machine;
import binnie.core.machines.storage.CompartmentTab;
import binnie.core.machines.storage.ComponentCompartmentInventory;
import binnie.core.machines.storage.ControlColourSelector;
import binnie.core.machines.transfer.TransferRequest;
import binnie.genetics.machine.craftgui.WindowMachine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowCompartment
extends WindowMachine
implements IWindowAffectsShiftClick {
    private final Map<Panel, Integer> panels = new HashMap<Panel, Integer>();
    boolean dueUpdate;
    private ControlTextEdit tabName;
    private ControlItemDisplay tabIcon;
    private ControlColourSelector tabColour;
    private int currentTab = 0;

    public WindowCompartment(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        super(320, 226, player, inventory, side);
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowCompartment(player, inventory, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        int x = 16;
        int y = 32;
        ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
        Integer[] tabs1 = new Integer[]{};
        Integer[] tabs2 = new Integer[]{};
        if (inv.getTabNumber() == 4) {
            tabs1 = new Integer[]{0, 1};
            tabs2 = new Integer[]{2, 3};
        }
        if (inv.getTabNumber() == 6) {
            tabs1 = new Integer[]{0, 1, 2};
            tabs2 = new Integer[]{3, 4, 5};
        }
        if (inv.getTabNumber() == 8) {
            tabs1 = new Integer[]{0, 1, 2, 3};
            tabs2 = new Integer[]{4, 5, 6, 7};
        }
        boolean doubleTabbed = tabs2.length > 0;
        int compartmentPageWidth = 16 + 18 * inv.getPageSize() / 5;
        int compartmentPageHeight = 106;
        int compartmentWidth = compartmentPageWidth + (doubleTabbed ? 48 : 24);
        int compartmentHeight = 106;
        Control controlCompartment = new Control(this, x, 32, compartmentWidth, 106);
        final ControlTabBar<Integer> tab = new ControlTabBar<Integer>((IWidget)controlCompartment, 0, 0, 24, 106, Position.LEFT, Arrays.asList(tabs1)){

            @Override
            public ControlTab<Integer> createTab(int x, int y, int w, int h, Integer value) {
                return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public ItemStack getItemStack() {
                        return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                    }

                    @Override
                    public String getName() {
                        return WindowCompartment.this.getTab((Integer)this.value).getName();
                    }

                    @Override
                    public int getOutlineColour() {
                        return WindowCompartment.this.getTab((Integer)this.value).getColor().getColor();
                    }

                    @Override
                    public boolean hasOutline() {
                        return true;
                    }
                };
            }
        };
        String[] tabHelp = new String[]{"Compartment Tab", "Tabs that divide the inventory into sections. Each one can be labelled seperately."};
        tab.addHelp(tabHelp);
        tab.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                NBTTagCompound nbt = new NBTTagCompound();
                int i = (Integer)event.getValue();
                nbt.func_74774_a("i", (byte)i);
                ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                WindowCompartment.this.currentTab = i;
            }
        }.setOrigin(EventHandler.Origin.DIRECT_CHILD, tab));
        x += 24;
        ControlPages compartmentPages = new ControlPages(controlCompartment, 24, 0, compartmentPageWidth, 106);
        ControlPage[] page = new ControlPage[inv.getTabNumber()];
        for (int p = 0; p < inv.getTabNumber(); ++p) {
            page[p] = new ControlPage<Integer>(compartmentPages, p);
        }
        CraftGUIUtil.linkWidgets(tab, compartmentPages);
        int i = 0;
        for (int p2 = 0; p2 < inv.getTabNumber(); ++p2) {
            ControlPage thisPage = page[p2];
            Panel panel = new Panel(thisPage, 0, 0, thisPage.getWidth(), thisPage.getHeight(), MinecraftGUI.PanelType.BLACK){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void onRenderForeground(int guiWidth, int guiHeight) {
                    Texture iTexture = CraftGUI.RENDER.getTexture((Object)CraftGUITexture.TAB_OUTLINE);
                    RenderUtil.setColour(WindowCompartment.this.getTab((Integer)WindowCompartment.this.panels.get(this)).getColor().getColor());
                    CraftGUI.RENDER.texture(iTexture, this.getArea().inset(3));
                }
            };
            this.panels.put(panel, p2);
            int[] slotsIDs = new int[inv.getPageSize()];
            for (int k = 0; k < inv.getPageSize(); ++k) {
                slotsIDs[k] = i++;
            }
            new ControlSlotArray.Builder(thisPage, 8, 8, inv.getPageSize() / 5, 5).create(slotsIDs);
        }
        x += compartmentPageWidth;
        if (tabs2.length > 0) {
            ControlTabBar<Integer> tab2 = new ControlTabBar<Integer>((IWidget)controlCompartment, 24 + compartmentPageWidth, 0, 24, 106, Position.RIGHT, Arrays.asList(tabs2)){

                @Override
                public ControlTab<Integer> createTab(int x, int y, int w, int h, Integer value) {
                    return new ControlTabIcon<Integer>((ControlTabBar)this, x, y, w, h, value){

                        @Override
                        public ItemStack getItemStack() {
                            return WindowCompartment.this.getTab((Integer)this.value).getIcon();
                        }

                        @Override
                        public String getName() {
                            return WindowCompartment.this.getTab((Integer)this.value).getName();
                        }

                        @Override
                        public int getOutlineColour() {
                            return WindowCompartment.this.getTab((Integer)this.value).getColor().getColor();
                        }

                        @Override
                        public boolean hasOutline() {
                            return true;
                        }
                    };
                }
            };
            tab2.addHelp(tabHelp);
            tab2.addEventHandler(new EventValueChanged.Handler(){

                @Override
                public void onEvent(EventValueChanged event) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    int i = (Integer)event.getValue();
                    nbt.func_74774_a("i", (byte)i);
                    ((Window)Window.get(tab)).sendClientAction("tab-change", nbt);
                    WindowCompartment.this.currentTab = i;
                }
            }.setOrigin(EventHandler.Origin.DIRECT_CHILD, tab2));
            CraftGUIUtil.linkWidgets(tab2, compartmentPages);
            x += 24;
        }
        x += 16;
        this.setSize(new Point(Math.max(32 + compartmentWidth, 252), this.getHeight()));
        controlCompartment.setPosition(new Point((this.getWidth() - controlCompartment.getWidth()) / 2, controlCompartment.getYPos()));
        ControlPlayerInventory invent = new ControlPlayerInventory((IWidget)this, true);
        ControlSlide slide = new ControlSlide(this, 0, 134, 136, 92, Position.LEFT);
        slide.setLabel("Tab Properties");
        slide.setSlide(false);
        slide.addHelp("Tab Properties");
        slide.addHelp("The label, colour and icon of the Tab can be altered here. Clicking on the icon with a held item will change it.");
        Panel tabPropertyPanel = new Panel(slide, 16, 8, 112, 76, MinecraftGUI.PanelType.GRAY);
        int y2 = 4;
        new ControlText((IWidget)tabPropertyPanel, new Point(4, y2), "Tab Name:");
        Panel parent = tabPropertyPanel;
        int x2 = 4;
        this.tabName = new ControlTextEdit(parent, 4, y2 += 12, 104, 12);
        this.tabName.addSelfEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                tab.setName((String)event.getValue());
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        }.setOrigin(EventHandler.Origin.SELF, this.tabName));
        new ControlText((IWidget)tabPropertyPanel, new Point(4, y2 += 20), "Tab Icon: ");
        this.tabIcon = new ControlItemDisplay(tabPropertyPanel, 58, y2 - 4);
        this.tabIcon.setItemStack(new ItemStack(Items.field_151121_aF));
        this.tabIcon.addAttribute(Attribute.MOUSE_OVER);
        this.tabIcon.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (WindowCompartment.this.getHeldItemStack() == null) {
                    return;
                }
                CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                ItemStack stack = WindowCompartment.this.getHeldItemStack().func_77946_l();
                stack.func_190920_e(1);
                tab.setIcon(stack);
                NBTTagCompound nbt = new NBTTagCompound();
                tab.writeToNBT(nbt);
                WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
            }
        });
        this.tabColour = new ControlColourSelector(tabPropertyPanel, 82, y2 - 4, 16, 16, EnumColor.WHITE);
        this.tabIcon.addHelp("Icon for Current Tab");
        this.tabIcon.addHelp("Click here with an item to change");
        new ControlText((IWidget)tabPropertyPanel, new Point(4, y2 += 20), "Colour: ");
        int cw = 8;
        Panel panelColour = new Panel(tabPropertyPanel, 40, y2 - 4, 66, 17, MinecraftGUI.PanelType.GRAY);
        for (int cc = 0; cc < 16; ++cc) {
            final ControlColourSelector color = new ControlColourSelector(panelColour, 1 + 8 * (cc % 8), 1 + 8 * (cc / 8), 8, 8, EnumColor.values()[cc]);
            color.addSelfEventHandler(new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    CompartmentTab tab = WindowCompartment.this.getCurrentTab();
                    tab.setColor(color.getValue());
                    NBTTagCompound nbt = new NBTTagCompound();
                    tab.writeToNBT(nbt);
                    WindowCompartment.this.sendClientAction("comp-change-tab", nbt);
                }
            });
            color.addHelp("Colour Selector");
            color.addHelp("Select a colour to highlight the current tab");
        }
        y2 += 20;
        ControlButton searchButton = new ControlButton(controlCompartment, compartmentWidth - 24 - 64 - 8, 106, 64, 16, "Search"){

            @Override
            @SideOnly(value=Side.CLIENT)
            protected void onMouseClick(EventMouse.Down event) {
                WindowCompartment.this.createSearchDialog();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderBackground(int guiWidth, int guiHeight) {
                CraftGUITexture texture = this.isMouseOver() ? CraftGUITexture.TAB_HIGHLIGHTED : CraftGUITexture.TAB;
                CraftGUI.RENDER.texture(CraftGUI.RENDER.getTexture((Object)texture).crop(Position.BOTTOM, 8), this.getArea());
            }
        };
        searchButton.addHelp("Search Button");
        searchButton.addHelp("Clicking this will open the Search dialog. This allows you to search the inventory for specific items.");
    }

    @SideOnly(value=Side.CLIENT)
    public void createSearchDialog() {
        new SearchDialog();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        this.updateTabs();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTabs() {
        this.tabName.setValue(this.getCurrentTab().getName());
        this.tabIcon.setItemStack(this.getCurrentTab().getIcon());
        this.tabColour.setValue(this.getCurrentTab().getColor());
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        super.receiveGuiNBTOnServer(player, name, nbt);
        if (name.equals("tab-change")) {
            this.currentTab = nbt.func_74771_c("i");
        }
    }

    @Override
    public String getTitle() {
        return "Compartment";
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.getInstance();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "compartment";
    }

    @Override
    public void alterRequest(TransferRequest request) {
        if (request.getDestination() == this.getInventory()) {
            ComponentCompartmentInventory inv = Machine.getMachine(this.getInventory()).getInterface(ComponentCompartmentInventory.class);
            request.setTargetSlots(inv.getSlotsForTab(this.currentTab));
        }
    }

    public CompartmentTab getTab(int i) {
        return Machine.getInterface(ComponentCompartmentInventory.class, this.getInventory()).getTab(i);
    }

    public CompartmentTab getCurrentTab() {
        return this.getTab(this.currentTab);
    }

    private class SearchDialog
    extends Dialog {
        Control slotGrid;
        String textSearch;
        boolean sortByName;
        boolean includeItems;
        boolean includeBlocks;

        public SearchDialog() {
            super(WindowCompartment.this, 252, 192);
            this.textSearch = "";
            this.sortByName = false;
            this.includeItems = true;
            this.includeBlocks = true;
        }

        @Override
        public void onClose() {
        }

        @Override
        public void initialise() {
            ControlScrollableContent<IWidget> scroll = new ControlScrollableContent<IWidget>((IWidget)this, 124, 16, 116, 92, 6){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void onRenderBackground(int guiWidth, int guiHeight) {
                    RenderUtil.setColour(0xAAAAAA);
                    CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, this.getArea().inset(new Border(0, 6, 0, 0)));
                }
            };
            this.slotGrid = new Control(scroll, 1, 1, 108, 18);
            scroll.setScrollableContent(this.slotGrid);
            new ControlPlayerInventory((IWidget)this, true);
            new ControlTextEdit(this, 16, 16, 100, 14).addEventHandler(new EventTextEdit.Handler(){

                @Override
                public void onEvent(EventTextEdit event) {
                    SearchDialog.this.textSearch = (String)event.value;
                    SearchDialog.this.updateSearch();
                }
            });
            this.includeItems = true;
            this.includeBlocks = true;
            new ControlCheckbox(this, 16, 40, 100, "Sort A-Z", this.sortByName){

                @Override
                protected void onValueChanged(boolean value) {
                    SearchDialog.this.sortByName = value;
                    SearchDialog.this.updateSearch();
                }
            };
            new ControlCheckbox(this, 16, 64, 100, "Include Items", this.includeItems){

                @Override
                protected void onValueChanged(boolean value) {
                    SearchDialog.this.includeItems = value;
                    SearchDialog.this.updateSearch();
                }
            };
            new ControlCheckbox(this, 16, 88, 100, "Include Blocks", this.includeBlocks){

                @Override
                protected void onValueChanged(boolean value) {
                    SearchDialog.this.includeBlocks = value;
                    SearchDialog.this.updateSearch();
                }
            };
            this.updateSearch();
        }

        private void updateSearch() {
            HashMap<Integer, Object> slotIds = new HashMap<Integer, Object>();
            IInventory inv = WindowCompartment.this.getInventory();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                String name = stack.func_82833_r().toLowerCase();
                if (this.textSearch != null && !name.contains(this.textSearch) || !this.includeBlocks && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || !this.includeItems && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                slotIds.put(i, name);
            }
            if (this.sortByName) {
                LinkedList list = new LinkedList(slotIds.entrySet());
                list.sort((o1, o2) -> -((String)o2.getValue()).compareTo((String)o1.getValue()));
                LinkedHashMap result = new LinkedHashMap();
                for (Map.Entry entry : list) {
                    result.put(entry.getKey(), entry.getValue());
                }
                slotIds = result;
            }
            int y = 0;
            int x = 0;
            int width = 108;
            int n = 2 + 18 * (1 + (slotIds.size() - 1) / 6);
            this.slotGrid.deleteAllChildren();
            this.slotGrid.setSize(new Point(108, n));
            Iterator iterator = slotIds.keySet().iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                new ControlSlot.Builder(this.slotGrid, x, y).assign(k);
                if ((x += 18) < 108) continue;
                x = 0;
                y += 18;
            }
            while (y < 108 || x != 0) {
                new ControlSlot.Builder(this.slotGrid, x, y);
                if ((x += 18) < 108) continue;
                x = 0;
                y += 18;
            }
        }
    }
}

