/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.errors;

import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.EnumErrorType;
import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.machines.errors.IErrorStateDefinition;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import net.minecraft.nbt.NBTTagCompound;

public class ErrorState
implements INbtReadable,
INbtWritable {
    private IErrorStateDefinition nameDefinition;
    private IErrorStateDefinition definition;
    private int[] data;
    private boolean progress;
    private boolean itemError;
    private boolean tankError;
    private boolean powerError;

    public ErrorState(IErrorStateDefinition definition) {
        this(definition, definition);
    }

    public ErrorState(IErrorStateDefinition definition, int[] data) {
        this(definition, definition, data);
    }

    public ErrorState(IErrorStateDefinition definition, int data) {
        this(definition, definition, new int[]{data});
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition) {
        this(nameDefinition, definition, new int[0]);
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int data) {
        this(nameDefinition, definition, new int[]{data});
    }

    public ErrorState(IErrorStateDefinition nameDefinition, IErrorStateDefinition definition, int[] data) {
        EnumErrorType type = definition.getType();
        this.data = data;
        this.progress = false;
        this.itemError = type.isItemError();
        this.tankError = type.isTankError();
        this.powerError = type.isPowerError();
        this.nameDefinition = nameDefinition;
        this.definition = definition;
    }

    public ErrorState(NBTTagCompound nbtTagCompound) {
        this.data = new int[0];
        this.progress = false;
        this.itemError = false;
        this.tankError = false;
        this.powerError = false;
        this.definition = CoreErrorCode.UNKNOWN;
        this.nameDefinition = CoreErrorCode.UNKNOWN;
        this.readFromNBT(nbtTagCompound);
    }

    public String toString() {
        return this.nameDefinition.getName();
    }

    public String getTooltip() {
        return this.definition.getDescription();
    }

    public int[] getData() {
        return this.data;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public void setIsProgress() {
        this.progress = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.nameDefinition = ErrorStateRegistry.getErrorState(nbt.func_74779_i("name"));
        this.definition = ErrorStateRegistry.getErrorState(nbt.func_74779_i("desc"));
        this.data = nbt.func_74759_k("data");
        this.itemError = nbt.func_74767_n("item");
        this.tankError = nbt.func_74767_n("tank");
        this.powerError = nbt.func_74767_n("power");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.nameDefinition.getUID());
        nbt.func_74778_a("desc", this.definition.getUID());
        nbt.func_74783_a("data", this.data);
        if (this.isItemError()) {
            nbt.func_74757_a("item", true);
        }
        if (this.isTankError()) {
            nbt.func_74757_a("tank", true);
        }
        if (this.isPowerError()) {
            nbt.func_74757_a("power", true);
        }
        return nbt;
    }

    public boolean isItemError() {
        return this.itemError;
    }

    public boolean isTankError() {
        return this.tankError;
    }

    public boolean isPowerError() {
        return this.powerError;
    }
}

