/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.BinnieCore;
import binnie.core.machines.IBlockMachine;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineGroup;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.util.TileUtil;
import com.google.common.base.Preconditions;
import forestry.core.utils.Translator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class BlockMachine
extends Block
implements IBlockMachine,
ITileEntityProvider {
    public static final PropertyInteger MACHINE_TYPE = PropertyInteger.func_177719_a((String)"machine_type", (int)0, (int)15);
    private MachineGroup group;

    public BlockMachine(MachineGroup group, String blockName) {
        super(Material.field_151573_f);
        this.group = group;
        this.func_149711_c(1.5f);
        this.setRegistryName(blockName);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (MachinePackage pack : this.group.getPackages()) {
            if (!pack.isActive()) continue;
            itemList.add((Object)new ItemStack((Block)this, 1, pack.getMetadata().intValue()));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MACHINE_TYPE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MACHINE_TYPE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE_TYPE});
    }

    @Override
    @Nullable
    public MachinePackage getPackage(int meta) {
        return this.group.getPackage(meta);
    }

    @Override
    public String getMachineName(int meta) {
        MachinePackage machinePackage = this.getPackage(meta);
        return machinePackage == null ? "Unnamed Machine" : machinePackage.getDisplayName();
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        if (GuiScreen.func_146272_n()) {
            MachinePackage machinePackage = this.getPackage(stack.func_77960_j());
            if (machinePackage != null) {
                tooltip.add(machinePackage.getInformation());
            }
        } else {
            tooltip.add(TextFormatting.ITALIC + "<" + Translator.translateToLocal((String)"for.gui.tooltip.tmi") + ">");
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MACHINE_TYPE);
    }

    public TileEntity func_149915_a(World world, int meta) {
        MachinePackage machinePackage = this.group.getPackage(meta);
        if (machinePackage == null) {
            machinePackage = this.group.getPackage(0);
            Preconditions.checkNotNull((Object)machinePackage, (String)"Machine has no packages %s", (Object[])new Object[]{this});
        }
        return machinePackage.createTileEntity();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!BinnieCore.getBinnieProxy().isSimulating(worldIn)) {
            return true;
        }
        if (playerIn.func_70093_af()) {
            return true;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
                IFluidHandler tileFluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                ItemStack heldItem = playerIn.func_184586_b(hand);
                FluidActionResult actionResult = FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)tileFluidHandler, (EntityPlayer)playerIn);
                if (actionResult.isSuccess()) {
                    playerIn.func_184611_a(hand, actionResult.getResult());
                    return true;
                }
            }
            if (tileEntity instanceof TileEntityMachine) {
                ((TileEntityMachine)tileEntity).getMachine().onRightClick(worldIn, playerIn, pos);
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityliving, ItemStack stack) {
        super.func_180633_a(world, pos, state, entityliving, stack);
        if (!BinnieCore.getBinnieProxy().isSimulating(world)) {
            return;
        }
        IMachine machine = Machine.getMachine(world.func_175625_s(pos));
        if (machine == null) {
            return;
        }
        if (entityliving instanceof EntityPlayer) {
            machine.setOwner(((EntityPlayer)entityliving).func_146103_bH());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityMachine entity = TileUtil.getTile((IBlockAccess)world, pos, TileEntityMachine.class);
        if (entity != null) {
            entity.onBlockDestroy();
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        IMachine machine;
        if (world.func_175667_e(pos) && (machine = Machine.getMachine(TileUtil.getTile((IBlockAccess)world, pos, TileEntity.class))) != null) {
            for (IRender.RandomDisplayTick renders : machine.getInterfaces(IRender.RandomDisplayTick.class)) {
                renders.onRandomDisplayTick(world, pos, rand);
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return world.func_175698_g(pos);
    }
}

