/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.fieldkit;

import binnie.Binnie;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.fieldkit.ControlChromoPicker;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.StandardTexture;
import binnie.core.texture.BinnieCoreTexture;
import com.google.common.base.Preconditions;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlChromosome
extends Control
implements IControlValue<IChromosomeType> {
    Texture BeeTexture = new StandardTexture(0, 0, 96, 96, BinnieCoreTexture.GUI_BREEDING);
    Texture TreeTexture = new StandardTexture(96, 0, 96, 96, BinnieCoreTexture.GUI_BREEDING);
    Texture MothTexture = new StandardTexture(96, 96, 96, 96, BinnieCoreTexture.GUI_BREEDING);
    Texture FlowerTexture = new StandardTexture(0, 96, 96, 96, BinnieCoreTexture.GUI_BREEDING);
    @Nullable
    IChromosomeType chromo = null;
    @Nullable
    ISpeciesRoot species = null;

    public ControlChromosome(IWidget parent, int x, int y) {
        super(parent, x, y, 96, 96);
    }

    public ISpeciesRoot getRoot() {
        Preconditions.checkState((this.species != null ? 1 : 0) != 0, (Object)"root has not been set");
        return this.species;
    }

    public void setRoot(@Nullable ISpeciesRoot root) {
        if (root != this.species) {
            this.species = root;
            this.deleteAllChildren();
            if (root == Binnie.GENETICS.getBeeRoot()) {
                new ControlChromoPicker(this, 28, 47, (IChromosomeType)EnumBeeChromosome.SPECIES);
                new ControlChromoPicker(this, 28, 72, (IChromosomeType)EnumBeeChromosome.SPEED);
                new ControlChromoPicker(this, 19, 20, (IChromosomeType)EnumBeeChromosome.LIFESPAN);
                new ControlChromoPicker(this, 55, 65, (IChromosomeType)EnumBeeChromosome.FERTILITY);
                new ControlChromoPicker(this, 28, 1, (IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE);
                new ControlChromoPicker(this, 61, 37, (IChromosomeType)EnumBeeChromosome.NEVER_SLEEPS);
                new ControlChromoPicker(this, 81, 76, (IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE);
                new ControlChromoPicker(this, 44, 21, (IChromosomeType)EnumBeeChromosome.TOLERATES_RAIN);
                new ControlChromoPicker(this, 3, 37, (IChromosomeType)EnumBeeChromosome.CAVE_DWELLING);
                new ControlChromoPicker(this, 4, 65, (IChromosomeType)EnumBeeChromosome.FLOWER_PROVIDER);
                new ControlChromoPicker(this, 83, 27, (IChromosomeType)EnumBeeChromosome.FLOWERING);
                new ControlChromoPicker(this, 71, 10, (IChromosomeType)EnumBeeChromosome.TERRITORY);
                new ControlChromoPicker(this, 84, 54, (IChromosomeType)EnumBeeChromosome.EFFECT);
            } else if (root == Binnie.GENETICS.getTreeRoot()) {
                new ControlChromoPicker(this, 48, 48, (IChromosomeType)EnumTreeChromosome.SPECIES);
                new ControlChromoPicker(this, 43, 84, (IChromosomeType)EnumTreeChromosome.HEIGHT);
                new ControlChromoPicker(this, 25, 63, (IChromosomeType)EnumTreeChromosome.FERTILITY);
                new ControlChromoPicker(this, 72, 57, (IChromosomeType)EnumTreeChromosome.FRUITS);
                new ControlChromoPicker(this, 21, 43, (IChromosomeType)EnumTreeChromosome.YIELD);
                new ControlChromoPicker(this, 15, 17, (IChromosomeType)EnumTreeChromosome.SAPPINESS);
                new ControlChromoPicker(this, 67, 15, (IChromosomeType)EnumTreeChromosome.EFFECT);
                new ControlChromoPicker(this, 70, 34, (IChromosomeType)EnumTreeChromosome.MATURATION);
                new ControlChromoPicker(this, 45, 67, (IChromosomeType)EnumTreeChromosome.GIRTH);
                new ControlChromoPicker(this, 5, 70, (IChromosomeType)EnumTreeChromosome.FIREPROOF);
            } else if (root == Binnie.GENETICS.getFlowerRoot()) {
                new ControlChromoPicker(this, 35, 81, EnumFlowerChromosome.SPECIES);
                new ControlChromoPicker(this, 36, 28, EnumFlowerChromosome.PRIMARY);
                new ControlChromoPicker(this, 27, 13, EnumFlowerChromosome.SECONDARY);
                new ControlChromoPicker(this, 47, 15, EnumFlowerChromosome.FERTILITY);
                new ControlChromoPicker(this, 54, 31, EnumFlowerChromosome.TERRITORY);
                new ControlChromoPicker(this, 15, 55, EnumFlowerChromosome.EFFECT);
                new ControlChromoPicker(this, 23, 38, EnumFlowerChromosome.LIFESPAN);
                new ControlChromoPicker(this, 17, 77, EnumFlowerChromosome.TEMPERATURE_TOLERANCE);
                new ControlChromoPicker(this, 52, 51, EnumFlowerChromosome.HUMIDITY_TOLERANCE);
                new ControlChromoPicker(this, 54, 80, EnumFlowerChromosome.PH_TOLERANCE);
                new ControlChromoPicker(this, 41, 42, EnumFlowerChromosome.SAPPINESS);
                new ControlChromoPicker(this, 37, 63, EnumFlowerChromosome.STEM);
            } else if (root == Binnie.GENETICS.getButterflyRoot()) {
                new ControlChromoPicker(this, 40, 40, (IChromosomeType)EnumButterflyChromosome.SPECIES);
                new ControlChromoPicker(this, 63, 32, (IChromosomeType)EnumButterflyChromosome.SIZE);
                new ControlChromoPicker(this, 32, 63, (IChromosomeType)EnumButterflyChromosome.SPEED);
                new ControlChromoPicker(this, 11, 27, (IChromosomeType)EnumButterflyChromosome.LIFESPAN);
                new ControlChromoPicker(this, 16, 12, (IChromosomeType)EnumButterflyChromosome.METABOLISM);
                new ControlChromoPicker(this, 17, 63, (IChromosomeType)EnumButterflyChromosome.FERTILITY);
                new ControlChromoPicker(this, 34, 12, (IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE);
                new ControlChromoPicker(this, 22, 46, (IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE);
                new ControlChromoPicker(this, 53, 26, (IChromosomeType)EnumButterflyChromosome.NOCTURNAL);
                new ControlChromoPicker(this, 71, 53, (IChromosomeType)EnumButterflyChromosome.TOLERANT_FLYER);
                new ControlChromoPicker(this, 78, 12, (IChromosomeType)EnumButterflyChromosome.FIRE_RESIST);
                new ControlChromoPicker(this, 55, 55, (IChromosomeType)EnumButterflyChromosome.FLOWER_PROVIDER);
                new ControlChromoPicker(this, 27, 31, (IChromosomeType)EnumButterflyChromosome.EFFECT);
                new ControlChromoPicker(this, 87, 45, (IChromosomeType)EnumButterflyChromosome.COCOON);
            }
        }
    }

    @Override
    public IChromosomeType getValue() {
        return this.chromo;
    }

    @Override
    public void setValue(IChromosomeType value) {
        this.chromo = value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (this.species == null) {
            return;
        }
        super.onRenderBackground(guiWidth, guiHeight);
        Texture text = this.getTypeTexture();
        CraftGUI.RENDER.texture(text, Point.ZERO);
    }

    @Nullable
    private Texture getTypeTexture() {
        if (this.species == Binnie.GENETICS.getBeeRoot()) {
            return this.BeeTexture;
        }
        if (this.species == Binnie.GENETICS.getTreeRoot()) {
            return this.TreeTexture;
        }
        if (this.species == Binnie.GENETICS.getButterflyRoot()) {
            return this.MothTexture;
        }
        if (this.species == Binnie.GENETICS.getFlowerRoot()) {
            return this.FlowerTexture;
        }
        return null;
    }
}

