/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IBlockSoil;
import binnie.botany.core.BotanyCore;
import binnie.botany.gardening.PlantType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlant
extends BlockBush
implements IItemModelRegister {
    public static final PropertyEnum<PlantType> PLANT_TYPE = PropertyEnum.func_177709_a((String)"plant_type", PlantType.class);

    public BlockPlant() {
        this.setRegistryName("plant");
        this.func_149647_a(CreativeTabBotany.instance);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public static boolean isWeed(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (!(blockState.func_177230_c() instanceof BlockPlant)) {
            return false;
        }
        PlantType type = (PlantType)((Object)blockState.func_177229_b(PLANT_TYPE));
        return type.isWeed();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        int index = 0;
        for (PlantType type : PlantType.values()) {
            manager.registerItemModel(item, index, type.func_176610_l());
            ++index;
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLANT_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((PlantType)((Object)state.func_177229_b(PLANT_TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.values()[meta]));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) || BotanyCore.getGardening().isSoil(worldIn.func_180495_p(pos).func_177230_c());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, NonNullList<ItemStack> subBlocks) {
        for (PlantType type : PlantType.values()) {
            subBlocks.add((Object)type.get());
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        PlantType type = (PlantType)((Object)state.func_177229_b(PLANT_TYPE));
        if (rand.nextInt(4) == 0) {
            if (type == PlantType.WEEDS) {
                world.func_180501_a(pos, state.func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.WEEDS_LONG)), 2);
            } else if (type == PlantType.WEEDS_LONG) {
                world.func_180501_a(pos, state.func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.WEEDS_VERY_LONG)), 2);
            } else if (type == PlantType.DEAD_FLOWER) {
                world.func_180501_a(pos, state.func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.DECAYING_FLOWER)), 2);
            } else if (type == PlantType.DECAYING_FLOWER) {
                world.func_175698_g(pos);
                return;
            }
        }
        if (rand.nextInt(6) == 0) {
            if (type == PlantType.WEEDS) {
                world.func_175698_g(pos);
            } else if (type == PlantType.WEEDS_LONG) {
                world.func_180501_a(pos, state.func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.WEEDS)), 2);
            } else if (type == PlantType.WEEDS_VERY_LONG) {
                world.func_180501_a(pos, state.func_177226_a(PLANT_TYPE, (Comparable)((Object)PlantType.WEEDS_LONG)), 2);
            }
        }
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!BotanyCore.getGardening().isSoil(below)) {
            return;
        }
        IBlockSoil soil = (IBlockSoil)below;
        if (rand.nextInt(3) != 0) {
            return;
        }
        if (type.isWeed()) {
            if (!soil.degrade(world, pos.func_177977_b(), EnumSoilType.LOAM)) {
                soil.degrade(world, pos.func_177977_b(), EnumSoilType.SOIL);
            }
        } else if (type == PlantType.DECAYING_FLOWER && !soil.fertilise(world, pos.func_177977_b(), EnumSoilType.LOAM)) {
            soil.fertilise(world, pos.func_177977_b(), EnumSoilType.FLOWERBED);
        }
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }
}

