package binnie.genetics.machine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.core.BinnieCore;
import binnie.core.machines.Machine;

@SideOnly(Side.CLIENT)
public class MachineRendererLab {
	public static MachineRendererLab instance = new MachineRendererLab();
	private final EntityItem dummyEntityItem;
	private final EntityItem[] itemSides;
	private long lastTick;

	public MachineRendererLab() {
		World world = Minecraft.func_71410_x().field_71441_e;
		this.dummyEntityItem = new EntityItem(world);
		this.itemSides = new EntityItem[]{new EntityItem(world), new EntityItem(world), new EntityItem(world), new EntityItem(world)};
	}

	public void renderMachine(Machine machine, double x, double y, double z, float partialTicks, int destroyStage) {
		GlStateManager.func_179094_E();
		int i1 = 0;
		BlockPos pos = machine.getTileEntity().func_174877_v();
		int ix = pos.func_177958_n();
		int iy = pos.func_177956_o();
		int iz = pos.func_177952_p();
		if (machine.getTileEntity() != null) {
			i1 = ix * iy * iz + ix * iy - ix * iz + iy * iz - ix + iy - iz;
		}
		float phase = (float) Math.max(0.0, Math.sin((System.currentTimeMillis() + i1) * 0.003));
		GlStateManager.func_179137_b(x + 0.5, y + 1.5, z + 0.5);
		GlStateManager.func_179114_b(180.0f, 0.0f, 0.0f, 1.0f);
		World world = machine.getWorld();
		LaboratoryMachine.ComponentGUIHolder holder = Machine.getInterface(LaboratoryMachine.ComponentGUIHolder.class, machine);
		Label_0591:
		{
			if (world != null && holder != null && !holder.getStack().func_190926_b()) {
				BinnieCore.getBinnieProxy().getMinecraftInstance();
				if (Minecraft.func_71375_t()) {
					final ItemStack stack = holder.getStack();
					this.dummyEntityItem.field_70170_p = world;
					this.dummyEntityItem.func_92058_a(stack);
					if (world.func_82737_E() != this.lastTick) {
						this.lastTick = world.func_82737_E();
						this.dummyEntityItem.func_70071_h_();
					}
					GlStateManager.func_179094_E();
					final EntityPlayer player = BinnieCore.getBinnieProxy().getPlayer();
					final double dx = ix + 0.5 - player.field_70142_S;
					final double dz = iz + 0.5 - player.field_70136_U;
					final double t = Math.atan2(dz, dx) * 180.0 / 3.1415;
					GlStateManager.func_179114_b(90.0f, 1.0f, 0.0f, 0.0f);
					GlStateManager.func_179109_b(0.0f, 0.0f, -0.55f);
					GlStateManager.func_179114_b(90.0f + (float) (-t), 0.0f, 0.0f, 1.0f);
					GlStateManager.func_179109_b(0.0f, -0.125f, 0.0f);
					GlStateManager.func_179152_a(1.2f, 1.2f, 1.2f);
					GlStateManager.func_179114_b(45.0f, 1.0f, 0.0f, 0.0f);
					GlStateManager.func_179109_b(0.0f, 0.1f, 0.1f);
					RenderManager renderManager = BinnieCore.getBinnieProxy().getMinecraftInstance().func_175598_ae();
					renderManager.func_188391_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
					GlStateManager.func_179121_F();
					int rot = 0;
					for (EntityItem item : this.itemSides) {
						GlStateManager.func_179094_E();
						item.field_70170_p = world;
						item.func_92058_a(stack);
						GlStateManager.func_179114_b(rot, 0.0f, 1.0f, 0.0f);
						GlStateManager.func_179114_b(180.0f, 1.0f, 0.0f, 0.0f);
						GlStateManager.func_179137_b(0.0, -1.13, 0.4);
						GlStateManager.func_179152_a(0.8f, 0.8f, 0.8f);
						renderManager.func_188391_a(item, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
						rot += 90;
						GlStateManager.func_179121_F();
					}
					break Label_0591;
				}
			}
			this.dummyEntityItem.func_92058_a(ItemStack.field_190927_a);
			for (final EntityItem item2 : this.itemSides) {
				item2.func_92058_a(ItemStack.field_190927_a);
			}
		}
		GlStateManager.func_179121_F();
	}
}
