package binnie.extrabees.genetics.effect;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.utils.Utils;

public enum ExtraBeesEffect implements IAlleleBeeEffect {
	ECTOPLASM{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(100) < 4) {
				if (world.func_175623_d(position) && (world.func_175677_d(position.func_177977_b(), false) || world.func_180495_p(position.func_177977_b()).func_177230_c() == ExtraBees.ectoplasm)) {
					world.func_175656_a(position, ExtraBees.ectoplasm.func_176223_P());
				}
				return storedData;
			}
			return storedData;
		}
	},
	ACID{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(100) < 6) {
				doAcid(world, position);
			}
			return storedData;
		}
	},
	SPAWN_ZOMBIE{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(200) < 2) {
				this.spawnMob(world, position, new ResourceLocation("zombie"));
			}
			return storedData;
		}
	},
	SPAWN_SKELETON{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(200) < 2) {
				this.spawnMob(world, position, new ResourceLocation("skeleton"));
			}
			return storedData;
		}
	},
	SPAWN_CREEPER{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(200) < 2) {
				this.spawnMob(world, position, new ResourceLocation("creeper"));
			}
			return storedData;
		}
	},
	LIGHTNING{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(position) && world instanceof WorldServer) {
				world.func_72942_c(new EntityBeeLightning(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p()));
			}
			return storedData;
		}
	},
	RADIOACTIVE{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (final EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
				int damage = 4;
				if (entity instanceof EntityPlayer) {
					final int count = wearsItems((EntityPlayer) entity);
					if (count > 3) {
						continue;
					}
					if (count > 2) {
						damage = 1;
					} else if (count > 1) {
						damage = 2;
					} else if (count > 0) {
						damage = 3;
					}
				}
				entity.func_70097_a(DamageSource.field_76377_j, damage);
			}
			return storedData;
		}
	},
	METEOR{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(100) < 1 && world.func_175710_j(position)) {
				world.func_72838_d(new EntitySmallFireball(world, position.func_177958_n(), position.func_177956_o() + 64, position.func_177952_p(), 0.0, -0.6, 0.0));
			}
			return storedData;
		}
	},
	HUNGER{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
				if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
					continue;
				}
				player.func_71024_bL().func_75113_a(4.0f);
				player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100));
			}
			return storedData;
		}
	},
	FOOD{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
				player.func_71024_bL().func_75122_a(2, 0.2f);
			}
			return storedData;
		}
	},
	BLINDNESS {
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
				if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
					continue;
				}
				player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
			}
			return storedData;
		}
	},
	CONFUSION{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
				if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
					continue;
				}
				player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200));
			}
			return storedData;
		}
	},
	FIREWORKS{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt( 8) < 1) {
				final FireworkCreator.Firework firework = new FireworkCreator.Firework();
				firework.setShape(FireworkCreator.Shape.Ball);
				firework.addColor(genome.getPrimary().getSpriteColour(0));
				firework.addColor(genome.getPrimary().getSpriteColour(0));
				firework.addColor(genome.getPrimary().getSpriteColour(1));
				firework.addColor(genome.getSecondary().getSpriteColour(0));
				firework.addColor(genome.getSecondary().getSpriteColour(0));
				firework.addColor(genome.getPrimary().getSpriteColour(1));
						firework.setTrail();
				final EntityFireworkRocket var11 = new EntityFireworkRocket(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), firework.getFirework());
				if (world.func_175710_j(position)) {
					world.func_72838_d(var11);
				}
			}
			return storedData;
		}
	},
	FESTIVAL{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt((this == ExtraBeesEffect.FIREWORKS) ? 8 : 12) < 1) {
				final FireworkCreator.Firework firework = new FireworkCreator.Firework();
				final EntityFireworkRocket var11 = new EntityFireworkRocket(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), firework.getFirework());
				if (world.func_175710_j(position)) {
					world.func_72838_d(var11);
				}
			}
			return storedData;
		}
	},
	BIRTHDAY{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt((this == ExtraBeesEffect.FIREWORKS) ? 8 : 12) < 1) {
				FireworkCreator.Firework firework = new FireworkCreator.Firework();
				firework.setShape(FireworkCreator.Shape.Star);
				firework.addColor(16768256);
				for (final Birthday birthday : ExtraBeesEffect.birthdays) {
					if (birthday.isToday()) {
						firework.addColor(16711680);
						firework.addColor(65280);
						firework.addColor(255);
						firework.setTrail();
						break;
					}
				}
				final EntityFireworkRocket var11 = new EntityFireworkRocket(world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), firework.getFirework());
				if (world.func_175710_j(position)) {
					world.func_72838_d(var11);
				}
			}
			return storedData;
		}
	},
	TELEPORT{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(80) > 1) {
				return storedData;
			}
			final List<Entity> entities = this.getEntities(Entity.class, genome, housing);
			if (entities.size() == 0) {
				return storedData;
			}
			Entity entity = entities.get(world.field_73012_v.nextInt(entities.size()));
			if (!(entity instanceof EntityLiving)) {
				return storedData;
			}
			int y = position.func_177956_o();
			if (y < 4) {
				y = 4;
			}
			if (!world.func_175623_d(position) || !world.func_175623_d(position.func_177984_a())) {
				return storedData;
			}
			entity.func_70634_a(position.func_177958_n(), y, position.func_177952_p());
			((EntityLiving) entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 10));
			return storedData;
		}
	},
	GRAVITY{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			final List<Entity> entities = this.getEntities(Entity.class, genome, housing);
			for (final Entity entity : entities) {
				float entityStrength = 1.0f;
				if (entity instanceof EntityPlayer) {
					entityStrength *= 100.0f;
				}
				double posX = position.func_177958_n() - entity.field_70165_t;
				double posY = position.func_177956_o() - entity.field_70163_u;
				double posZ = position.func_177952_p() - entity.field_70161_v;
				if (posX * posX + posY * posY + posZ * posZ < 2.0) {
					return storedData;
				}
				final double strength = 0.5 / (posX * posX + posY * posY + posZ * posZ) * entityStrength;
				entity.func_70024_g(posX * strength, posY * strength, posZ * strength);
			}
			return storedData;
		}
	},
	THIEF{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			final List<EntityPlayer> players = this.getEntities(EntityPlayer.class, genome, housing);
			for (EntityPlayer player : players) {
				final double posX = position.func_177958_n() - player.field_70165_t;
				final double posY = position.func_177956_o() - player.field_70163_u;
				final double posZ = position.func_177952_p() - player.field_70161_v;
				if (posX * posX + posY * posY + posZ * posZ < 2.0) {
					return storedData;
				}
				final double strength = 0.5 / (posX * posX + posY * posY + posZ * posZ);
				player.func_70024_g(-posX * strength, -posY * strength, -posZ * strength);
			}
			return storedData;
		}
	},
	WITHER{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			//TODO: add function ?
			return storedData;
		}
	},
	WATER{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(120) > 1) {
				return storedData;
			}
			IFluidHandler fluidHandler = Utils.getCapability(world, position, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
			if (fluidHandler != null) {
				fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
				return storedData;
			}
			return storedData;
		}
	},
	SLOW{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			for (EntityPlayer player : this.getEntities(EntityPlayer.class, genome, housing)) {
				if (world.field_73012_v.nextInt(4) < wearsItems(player)) {
					continue;
				}
				player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200));
			}
			return storedData;
		}
	},
	BONEMEAL_SAPLING{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(20) > 1) {
				return storedData;
			}
			if (ExtraBeesFlowers.SAPLING.isAcceptedFlower(world, position)) {
				ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, position);
				return storedData;
			}
			return storedData;
		}
	},
	BONEMEAL_FRUIT{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(20) > 1) {
				return storedData;
			}
			if (ExtraBeesFlowers.FRUIT.isAcceptedFlower(world, position)) {
				ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, position);
				return storedData;
			}
			return storedData;
		}
	},
	BONEMEAL_MUSHROOM{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			if (world.field_73012_v.nextInt(20) > 1) {
				return storedData;
			}
			IBlockState blockState = world.func_180495_p(position);
			if (blockState.func_177230_c() == Blocks.field_150338_P || blockState.func_177230_c() == Blocks.field_150337_Q) {
				ItemDye.func_179234_a(new ItemStack(Blocks.field_150346_d, 1), world, position);
				return storedData;
			}
			return storedData;
		}
	},
	POWER{
		@Override
		protected IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position) {
			final TileEntity tile2 = world.func_175625_s(position);
			if (tile2.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) {
				IEnergyStorage storage = tile2.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP);
				storage.receiveEnergy(5, false);
			}
			return storedData;
		}
	};

	private static final List<Birthday> birthdays = new ArrayList<>();

	static {
		birthdays.add(new Birthday(3, 10, "Binnie"));
	}

	private String fx;
	private boolean combinable;
	private boolean dominant;
	private int id;
	private String uid;

	ExtraBeesEffect() {
		this.fx = "";
		this.uid = this.toString().toLowerCase();
		this.combinable = false;
		this.dominant = true;
	}

	public static void doInit() {
		ExtraBeesEffect.BLINDNESS.setFX("blindness");
		ExtraBeesEffect.FOOD.setFX("food");
		ExtraBeesEffect.GRAVITY.setFX("gravity");
		ExtraBeesEffect.THIEF.setFX("gravity");
		ExtraBeesEffect.TELEPORT.setFX("gravity");
		ExtraBeesEffect.LIGHTNING.setFX("lightning");
		ExtraBeesEffect.METEOR.setFX("meteor");
		ExtraBeesEffect.RADIOACTIVE.setFX("radioactive");
		ExtraBeesEffect.WATER.setFX("water");
		ExtraBeesEffect.WITHER.setFX("wither");
		for (final ExtraBeesEffect effect : values()) {
			effect.register();
		}
	}

	public static void doAcid(final World world, final BlockPos pos) {
		final IBlockState blockState = world.func_180495_p(pos);
		final Block block = blockState.func_177230_c();
		if (block == Blocks.field_150347_e || block == Blocks.field_150348_b) {
			world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
		} else if (block == Blocks.field_150346_d | block == Blocks.field_150349_c) {
			world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
		}
	}

	public static int wearsItems(final EntityPlayer player) {
		return BeeManager.armorApiaristHelper.wearsItems(player, "", false);
	}

	public void register() {
		AlleleManager.alleleRegistry.registerAllele(this);
	}

	@Override
	public boolean isCombinable() {
		return this.combinable;
	}

	@Override
	public IEffectData validateStorage(final IEffectData storedData) {
		return storedData;
	}

	@Override
	public String getName() {
		return I18n.func_74838_a("effect." + this.name().toLowerCase() + ".name");
	}

	@Override
	public boolean isDominant() {
		return this.dominant;
	}

	public void spawnMob(World world, BlockPos pos, ResourceLocation name) {
		if (this.anyPlayerInRange(world, pos, 16)) {
			double particleX = pos.func_177958_n() + world.field_73012_v.nextFloat();
			double particleY = pos.func_177956_o() + world.field_73012_v.nextFloat();
			double particleZ = pos.func_177952_p() + world.field_73012_v.nextFloat();
			world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
			world.func_175688_a(EnumParticleTypes.FLAME, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
			EntityLiving entity = (EntityLiving) EntityList.func_188429_b(name, world);
			if (entity != null) {
				int nearbyEntityCount = world.func_72872_a(entity.getClass(), new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b(8.0, 4.0, 8.0)).size();
				if (nearbyEntityCount < 6) {
					double posX = pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
					double posY = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
					double posZ = pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
					entity.func_70012_b(posX, posY, posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
					if (entity.func_70601_bi()) {
						world.func_72838_d(entity);
						world.func_175718_b(2004, pos, 0);//playSFX
						entity.func_70656_aK();
					}
				}
			}
		}
	}

	private boolean anyPlayerInRange(final World world, final BlockPos pos, final int distance) {
		return world.func_184137_a(pos.func_177958_n() + 0.5, pos.func_177956_o() + 0.5, pos.func_177952_p() + 0.5, distance, false) != null;
	}

	@Override
	public String getUID() {
		return "extrabees.effect." + this.uid;
	}

	protected abstract IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing, World world, BlockPos position);

	@Override
	public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
		final World world = housing.getWorldObj();
		BlockPos coordinates = housing.getCoordinates();
		int xHouse = coordinates.func_177958_n();
		int yHouse = coordinates.func_177956_o();
		int zHouse = coordinates.func_177952_p();
		Vec3i area = this.getModifiedArea(genome, housing);
		int offsetX = 1 + area.func_177958_n() / 2;
		int offsetY = 1 + area.func_177956_o() / 2;
		int offsetZ = 1 + area.func_177952_p() / 2;
		int xPos = xHouse - offsetX + world.field_73012_v.nextInt(2 * offsetX + 1);
		int yPos = yHouse - offsetY + world.field_73012_v.nextInt(2 * offsetY + 1);
		int zPos = zHouse - offsetZ + world.field_73012_v.nextInt(2 * offsetZ + 1);
		BlockPos position = new BlockPos(xPos, yPos, zPos);
		doEffect(genome, storedData, housing, world, position);
		return storedData;
	}

	protected Vec3i getModifiedArea(final IBeeGenome genome, final IBeeHousing housing) {
		Vec3i territory = genome.getTerritory();
		territory = new Vec3i(
			territory.func_177958_n() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f),
			territory.func_177956_o() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f),
			territory.func_177952_p() * (int) (BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f)
		);
		if (territory.func_177958_n() < 1) {
			territory = new Vec3i(1, territory.func_177956_o(), territory.func_177952_p());
		}
		if (territory.func_177956_o() < 1) {
			territory = new Vec3i(territory.func_177958_n(), 1, territory.func_177952_p());
		}
		if (territory.func_177952_p() < 1) {
			territory = new Vec3i(territory.func_177958_n(), territory.func_177956_o(), 1);
		}
		return territory;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public IEffectData doFX(final IBeeGenome genome, final IEffectData storedData, final IBeeHousing housing) {
		IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
		List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
		ParticleRender.addBeeHiveFX(housing, genome, flowerPositions);
		return storedData;
	}

	public String getFX() {
		return this.fx;
	}

	private void setFX(String string) {
		this.fx = "particles/" + string;
	}

	public <T extends Entity> List<T> getEntities(Class<T> eClass, IBeeGenome genome, IBeeHousing housing) {
		final Vec3i area = genome.getTerritory();
		BlockPos coordinates = housing.getCoordinates();
		int[] offset = {-Math.round(area.func_177958_n() / 2), -Math.round(area.func_177956_o() / 2), -Math.round(area.func_177952_p() / 2)};
		int[] min = {coordinates.func_177958_n() + offset[0], coordinates.func_177956_o() + offset[1], coordinates.func_177952_p() + offset[2]};
		int[] max = {coordinates.func_177958_n() + offset[0] + area.func_177958_n(), coordinates.func_177956_o() + offset[1] + area.func_177956_o(), coordinates.func_177952_p() + offset[2] + area.func_177952_p()};
		AxisAlignedBB box = new AxisAlignedBB(min[0], min[1], min[2], max[0], max[1], max[2]);
		return housing.getWorldObj().func_72872_a(eClass, box);
	}

	@Override
	public String getUnlocalizedName() {
		return this.getUID();
	}

	public static class Birthday {

		private final int month;
		private final int date;
		private final String name;

		private Birthday(final int month, final int date, final String name) {
			this.month = month;
			this.date = date + 1;
			this.name = name;
		}

		public boolean isToday() {
			return Calendar.getInstance().get(Calendar.DATE) == this.date && Calendar.getInstance().get(Calendar.MONTH) == this.month;
		}

		public String getName() {
			return this.name;
		}
	}
}
