/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.utils.config;

import binnie.extrabees.utils.config.IConfigurable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    private final Configuration config;
    private final Set<IConfigurable> configurables;

    public ConfigHandler(File location) {
        this.config = new Configuration(location);
        this.configurables = Sets.newHashSet();
    }

    public boolean addConfigurable(IConfigurable configurable) {
        return this.configurables.add((IConfigurable)Preconditions.checkNotNull((Object)configurable));
    }

    public void reload(boolean load) {
        if (load) {
            this.config.load();
        }
        for (IConfigurable configurable : this.configurables) {
            configurable.configure(this.config);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

