/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.liquid.BinnieFluid;
import binnie.core.liquid.FluidContainerType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;

public class FluidHandlerItemBinnie
extends FluidHandlerItemStackSimple {
    private final FluidContainerType containerType;

    public FluidHandlerItemBinnie(ItemStack container, FluidContainerType containerType) {
        super(container, 1000);
        this.containerType = containerType;
    }

    private boolean contentsAllowed(FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        if (fluid instanceof BinnieFluid) {
            BinnieFluid binnieFluid = (BinnieFluid)fluid;
            return binnieFluid.getType().canPlaceIn(this.containerType);
        }
        return false;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.contentsAllowed(fluid);
    }

    protected void setContainerToEmpty() {
        super.setContainerToEmpty();
        this.container.func_77964_b(0);
    }

    protected void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.container.func_77964_b(1);
    }
}

