package binnie.genetics.machine;

import javax.annotation.Nonnull;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import binnie.core.machines.IMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.network.INetwork;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.machine.acclimatiser.PackageAcclimatiser;
import binnie.genetics.machine.analyser.PackageAnalyser;
import binnie.genetics.machine.genepool.PackageGenepool;
import binnie.genetics.machine.incubator.PackageIncubator;

public enum LaboratoryMachine implements IMachineType {
	LabMachine(PackageLabMachine.class),
	Analyser(PackageAnalyser.class),
	Incubator(PackageIncubator.class),
	Genepool(PackageGenepool.class),
	Acclimatiser(PackageAcclimatiser.class);

	Class<? extends MachinePackage> clss;

	LaboratoryMachine(final Class<? extends MachinePackage> clss) {
		this.clss = clss;
	}

	@Override
	public Class<? extends MachinePackage> getPackageClass() {
		return this.clss;
	}

	@Override
	public boolean isActive() {
		return true;
	}

	public ItemStack get(final int amount) {
		Genetics.machine();
		return new ItemStack(ModuleMachine.packageLabMachine.getBlock(), amount, this.ordinal());
	}

	public static class PackageLabMachine extends GeneticMachine.PackageGeneticBase {
		public PackageLabMachine() {
			super("lab_machine", GeneticsTexture.LAB_MACHINE, 16777215, false);
		}

		@Override
		public void createMachine(final Machine machine) {
			new ComponentGUIHolder(machine);
		}

		/*@Override
		public void renderMachine(final Machine machine, final double x, final double y, final double z, final float var8, final RenderBlocks renderer) {
			MachineRendererLab.instance.renderMachine(machine, this.colour, this.renderTexture, x, y, z, var8);
		}*/
	}

	public static class ComponentGUIHolder extends MachineComponent implements INetwork.TilePacketSync, IInteraction.RightClick {
		@Nonnull
		private ItemStack stack = ItemStack.field_190927_a;

		public ComponentGUIHolder(final IMachine machine) {
			super(machine);
		}

		public ItemStack getStack() {
			return this.stack;
		}

		@Override
		public void readFromNBT(final NBTTagCompound nbttagcompound) {
			super.readFromNBT(nbttagcompound);
			this.stack = new ItemStack(nbttagcompound.func_74775_l("Item"));
		}

		@Override
		public NBTTagCompound writeToNBT(final NBTTagCompound nbttagcompound1) {
			NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound1);
			final NBTTagCompound nbt = new NBTTagCompound();
			if (!this.stack.func_190926_b()) {
				this.stack.func_77955_b(nbt);
			}
			nbttagcompound.func_74782_a("Item", nbt);
			return nbttagcompound;
		}

		@Override
		public void syncToNBT(final NBTTagCompound nbt) {
			this.writeToNBT(nbt);
		}

		@Override
		public void syncFromNBT(final NBTTagCompound nbt) {
			this.readFromNBT(nbt);
		}

		@Override
		public void onDestruction() {
			super.onDestruction();
			if (!this.stack.func_190926_b()) {
				final float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				final float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				final float f3 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
				if (this.stack.func_190916_E() == 0) {
					this.stack.func_190920_e(1);
				}
				final EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), this.getMachine().getTileEntity().func_174877_v().func_177958_n() + f, this.getMachine().getTileEntity().func_174877_v().func_177956_o() + f2, this.getMachine().getTileEntity().func_174877_v().func_177952_p() + f3, this.stack.func_77946_l());
				final float accel = 0.05f;
				entityitem.field_70159_w = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
				entityitem.field_70181_x = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel + 0.2f;
				entityitem.field_70179_y = (float) this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
				this.getMachine().getWorld().func_72838_d(entityitem);
			}
		}

		@Override
		public void onRightClick(World p0, EntityPlayer p1, BlockPos pos) {

		}
		/*@Override
		public void onRightClick(final World world, final EntityPlayer player, final int x, final int y, final int z) {
			if (BinnieCore.proxy.isSimulating(world) && player.getHeldItem() != null) {
				if (!this.stack.isEmpty() && player.getHeldItem().getItem() instanceof IToolWrench) {
					final float f = 0.7f;
					final double d0 = world.rand.nextFloat() * f + (1.0f - f) * 0.5;
					final double d2 = world.rand.nextFloat() * f + (1.0f - f) * 0.5;
					final double d3 = world.rand.nextFloat() * f + (1.0f - f) * 0.5;
					final EntityItem entityitem = new EntityItem(world, x + d0, y + d2, z + d3, this.stack);
					entityitem.delayBeforeCanPickup = 10;
					world.spawnEntity(entityitem);
					this.stack = null;
					((IToolWrench) player.getHeldItem().getItem()).wrenchUsed(player, x, y, z);
					this.getUtil().refreshBlock();
					return;
				}
				final List<Item> validSelections = new ArrayList<Item>();
				if (BinnieCore.isBotanyActive()) {
					validSelections.add(Botany.database);
				}
				if (BinnieCore.isExtraBeesActive()) {
					validSelections.add(ExtraBees.dictionary);
				}
				if (BinnieCore.isExtraTreesActive()) {
					validSelections.add(ExtraTrees.itemDictionary);
				}
				if (BinnieCore.isLepidopteryActive()) {
					validSelections.add(ExtraTrees.itemDictionaryLepi);
				}
				validSelections.add(Genetics.database);
				validSelections.add(Genetics.analyst);
				validSelections.add(Genetics.registry);
				validSelections.add(Genetics.masterRegistry);
				validSelections.add(BinnieCore.genesis);
				if (this.stack.isEmpty() && validSelections.contains(player.getHeldItem().getItem())) {
					this.stack = player.getHeldItem().copy();
					final ItemStack heldItem = player.getHeldItem();
					heldItem.shrink(1);
					world.markBlockForUpdate(x, y, z);
					return;
				}
				if (!this.stack.isEmpty() && player.getHeldItem().getItem() instanceof IToolWrench) {
					this.stack.getItem().onItemRightClick(this.stack, world, player);
				}
			}
			if (!this.stack.isEmpty()) {
				this.stack.getItem().onItemRightClick(this.stack, world, player);
			}
		}*/
	}
}
