package binnie.extrabees.worldgen;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.blocks.BlockExtraBeeHive;
import binnie.extrabees.blocks.type.EnumHiveType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

import java.util.HashSet;
import java.util.Random;

public class WorldGenHiveMarble extends WorldGenHive {
	HashSet<Block> validBlocks = new HashSet<>();

	public WorldGenHiveMarble(int rate) {
		super(rate);
		//TODO config option / more ore names
		OreDictionary.getOres("stoneMarble").stream().filter(s -> s.func_77973_b() instanceof ItemBlock).map(s -> ((ItemBlock) s.func_77973_b()).func_179223_d()).forEach(validBlocks::add);
	}

	@Override
	public boolean func_180709_b(World world, Random rand, BlockPos position) {
		Block blockAtPos = world.func_180495_p(position).func_177230_c();
		if (world.func_175623_d(position) || !validBlocks.contains(blockAtPos)) {
			return false;
		}

		//generate when one face is different from marble
		int otherFace = 0;
		for (EnumFacing face : EnumFacing.values()) {
			if (!world.func_180495_p(position.func_177972_a(face)).func_177230_c().equals(blockAtPos)) {
				otherFace++;
				if (otherFace > 1) {
					return true;
				}
			}
		}

		world.func_175656_a(position, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, EnumHiveType.Marble));

		return true;
	}
}
