package binnie.core.util;

import javax.annotation.Nullable;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class FakeCraftingWorld extends World {
	private static final WorldSettings worldSettings = new WorldSettings(0, GameType.SURVIVAL, false, false, WorldType.field_77137_b);
	private static final WorldInfo worldInfo = new WorldInfo(worldSettings, "fake");
	private static final ISaveHandler saveHandler = new FakeSaveHandler();
	private static final WorldProvider worldProvider = new WorldProvider() {
		@Override
		public DimensionType func_186058_p() {
			return DimensionType.OVERWORLD;
		}
	};
	@Nullable
	private static FakeCraftingWorld INSTANCE;

	private FakeCraftingWorld() {
		super(saveHandler, worldInfo, worldProvider, new Profiler(), true);
		this.field_73011_w.func_76558_a(this);
		this.field_72988_C = new FakeMapStorage();
	}

	public static FakeCraftingWorld getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new FakeCraftingWorld();
		}
		return INSTANCE;
	}

	@Override
	public BlockPos func_175694_M() {
		return new BlockPos(0, 0, 0);
	}

	@Override
	public IBlockState func_180495_p(BlockPos pos) {
		return Blocks.field_150350_a.func_176223_P();
	}

	@Override
	protected IChunkProvider func_72970_h() {
		throw new UnsupportedOperationException();
	}

	@Override
	protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
		return false;
	}
}
