package binnie.core.multiblock;

import javax.annotation.Nullable;

import net.minecraft.tileentity.TileEntity;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;

class TileEntityMultiblockMachine extends TileEntity {
	private boolean inStructure;
	private int tileX;
	private int tileY;
	private int tileZ;

	boolean inStructure() {
		return this.inStructure;
	}

	@Nullable
	public Machine getMachine() {
		return this.getMasterMachine();
	}

	@Nullable
	private Machine getMasterMachine() {
		if (!this.inStructure) {
			return null;
		}
		final TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(this.tileX, this.tileY, this.tileZ));
		if (tile instanceof TileEntityMachine) {
			return ((TileEntityMachine) tile).getMachine();
		}
		return null;
	}
}
