package binnie.core.machines;

import net.minecraft.nbt.NBTTagCompound;

import binnie.Binnie;
import binnie.core.machines.base.TileEntityMachineBase;
import binnie.core.machines.component.IInteraction;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.PacketPayload;

public class TileEntityMachine extends TileEntityMachineBase implements INetworkedEntity {
	private Machine machine;

	public TileEntityMachine(final MachinePackage pack) {
		this.setMachine(pack);
	}

	public TileEntityMachine() {
	}

	@Override
	public void func_73660_a() {
		super.func_73660_a();
		if (this.machine != null) {
			this.machine.onUpdate();
		}
	}

	@Override
	public void func_145839_a(final NBTTagCompound nbtTagCompound) {
		super.func_145839_a(nbtTagCompound);
		final String name = nbtTagCompound.func_74779_i("name");
		final String group = nbtTagCompound.func_74779_i("group");
		final MachinePackage pack = Binnie.MACHINE.getPackage(group, name);
		if (pack == null) {
			this.func_145843_s();
			return;
		}
		this.setMachine(pack);
		this.getMachine().readFromNBT(nbtTagCompound);
	}

	@Override
	public NBTTagCompound func_189515_b(final NBTTagCompound nbtTagCompound2) {
		NBTTagCompound nbtTagCompound = super.func_189515_b(nbtTagCompound2);
		final String name = this.machine.getPackage().getUID();
		final String group = this.machine.getPackage().getGroup().getUID();
		nbtTagCompound.func_74778_a("group", group);
		nbtTagCompound.func_74778_a("name", name);
		this.getMachine().writeToNBT(nbtTagCompound);
		return nbtTagCompound;
	}

	@Override
	public void writeToPacket(final PacketPayload payload) {
		this.machine.writeToPacket(payload);
	}

	@Override
	public void readFromPacket(final PacketPayload payload) {
		this.machine.readFromPacket(payload);
	}

	public Machine getMachine() {
		return this.machine;
	}

	public void setMachine(final MachinePackage pack) {
		if (pack != null) {
			this.machine = new Machine(pack, this);
		}
	}

	public void onBlockDestroy() {
		if (this.getMachine() != null) {
			this.getMachine().onBlockDestroy();
		}
	}

	@Override
	public void func_145843_s() {
		super.func_145843_s();
		for (final IInteraction.Invalidation c : this.getMachine().getInterfaces(IInteraction.Invalidation.class)) {
			c.onInvalidation();
		}
	}

	@Override
	public void onChunkUnload() {
		super.onChunkUnload();
		for (final IInteraction.ChunkUnload c : this.getMachine().getInterfaces(IInteraction.ChunkUnload.class)) {
			c.onChunkUnload();
		}
	}
}
