package binnie.core.block;

import com.google.common.base.Preconditions;

import javax.annotation.Nullable;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityMetadata extends TileEntity {
	private int meta;
	private boolean droppedBlock;

	public TileEntityMetadata() {
		this.droppedBlock = false;
	}

	@Nullable
	public static TileEntityMetadata getTile(final IBlockAccess world, final BlockPos pos) {
		final TileEntity tile = world.func_175625_s(pos);
		if (!(tile instanceof TileEntityMetadata)) {
			return null;
		}
		return (TileEntityMetadata) tile;
	}

	public static ItemStack getItemStack(final Block block, final int damage) {
		final Item item = Item.func_150898_a(block);
		Preconditions.checkNotNull(item, "Could not get item for block %s", block);
		final ItemStack itemStack = new ItemStack(item, 1, 0);
		setItemDamage(itemStack, damage);
		return itemStack;
	}

	public static void setItemDamage(final ItemStack item, final int i) {
		item.func_77964_b((i < 16387) ? i : 16387);
		final NBTTagCompound tag = new NBTTagCompound();
		tag.func_74768_a("meta", i);
		item.func_77982_d(tag);
	}

	public static int getItemDamage(final ItemStack item) {
		if (item.func_77942_o() && item.func_77978_p().func_74764_b("meta")) {
			return item.func_77978_p().func_74762_e("meta");
		}
		return item.func_77952_i();
	}

	public static int getTileMetadata(final IBlockAccess world, final BlockPos pos) {
		final TileEntityMetadata tile = getTile(world, pos);
		return (tile == null) ? 0 : tile.getTileMetadata();
	}

	@Override
	public boolean func_145842_c(final int id, final int type) {
		if (id == 42) {
			this.meta = type;
			func_70296_d();
		}
		return true;
	}

	@Override
	public NBTTagCompound func_189517_E_() {
		return func_189515_b(new NBTTagCompound());
	}

	@Override
	public void func_145839_a(final NBTTagCompound nbt) {
		super.func_145839_a(nbt);
		if(field_145850_b!=null)
			setTileMetadata(nbt.func_74762_e("meta"), field_145850_b.field_72995_K);
		else
			this.meta = nbt.func_74762_e("meta");
	}

	@Override
	public NBTTagCompound func_189515_b(final NBTTagCompound nbt) {
		super.func_189515_b(nbt);
		nbt.func_74768_a("meta", this.meta);
		return nbt;
	}

	public int getTileMetadata() {
		return this.meta;
	}

	public void setTileMetadata(final int meta, final boolean notify) {
		if (this.meta != meta) {
			this.meta = meta;
			if (notify) {
				IBlockState state = field_145850_b.func_180495_p(field_174879_c);
				field_145850_b.func_184138_a(field_174879_c, state, state, 3);
			}
		}
	}

	@Override
	public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
		super.onDataPacket(net, pkt);
		func_145839_a(pkt.func_148857_g());
	}

	@Override
	public SPacketUpdateTileEntity func_189518_D_() {
		return new SPacketUpdateTileEntity(field_174879_c, 0, func_189517_E_());
	}

	public boolean hasDroppedBlock() {
		return this.droppedBlock;
	}

	public void dropBlock() {
		this.droppedBlock = true;
	}
}
