package binnie.botany.ceramic.brick;

import com.google.common.base.Preconditions;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.botany.Botany;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.util.I18N;

public class CeramicBrickPair {
	public static final CeramicBrickPair EMPTY = new CeramicBrickPair(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkSeaGreen, CeramicBrickType.TILE);

	public final EnumFlowerColor colorFirst;
	public final EnumFlowerColor colorSecond;

	public CeramicBrickType type;
	public int ordinal;

	CeramicBrickPair(EnumFlowerColor colorFirst, EnumFlowerColor colorSecond, CeramicBrickType type) {
		this.colorFirst = colorFirst;
		this.colorSecond = colorSecond;
		this.type = type;
		ordinal = colorFirst.ordinal() + colorSecond.ordinal() * 256 + type.ordinal() * 256 * 256;
	}

	public CeramicBrickPair(ItemStack stack) {
		this(getId(stack));
	}

	public CeramicBrickPair(int id) {
		colorFirst = EnumFlowerColor.get(id & 0xFF);
		colorSecond = EnumFlowerColor.get(id >> 8 & 0xFF);
		type = CeramicBrickType.get(id >> 16 & 0xFF);
	}

	public boolean isTwoColors() {
		return type.canDouble() && colorSecond != colorFirst;
	}

	public static int getId(ItemStack stack){
		if(!stack.func_77942_o()){
			return EMPTY.ordinal();
		}
		NBTTagCompound nbtTagCompound = stack.func_77978_p();
		return nbtTagCompound.func_74762_e("id");
	}

	public ItemStack getStack(int i) {
		ItemStack stack = new ItemStack(Botany.gardening().ceramicBrick, i);
		stack.func_77983_a("id", new NBTTagInt(ordinal()));
		return stack;
	}

	public String getName() {
		String name = colorFirst.getFlowerColorAllele().getColorName();
		if (type.canDouble() && colorSecond != colorFirst) {
			name = name + " & " + colorSecond.getFlowerColorAllele().getColorName();
		}
		return I18N.localise("botany.ceramic.type." + type.id + ".name", name);
	}

	public int ordinal() {
		return ordinal;
	}

	@SideOnly(Side.CLIENT)
	public TextureAtlasSprite getSprite(int pass) {
		TextureAtlasSprite[] sprites = type.sprites;
		Preconditions.checkState(sprites != null, "Sprites have not been registered.");
		return sprites[pass];
	}

	@Override
	public int hashCode() {
		return Integer.hashCode(type.ordinal());
	}

	@Override
	public boolean equals(Object obj) {
		return obj instanceof CeramicBrickPair
				&& ((CeramicBrickPair) obj).type == type;
	}
}
