/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.init;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.alveary.BlockAlveary;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.blocks.BlockEctoplasm;
import binnie.extrabees.blocks.BlockExtraBeeHive;
import binnie.extrabees.blocks.type.EnumHiveType;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.utils.HiveDrop;
import binnie.extrabees.utils.Utils;
import binnie.extrabees.utils.config.ConfigurationMain;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.apiculture.genetics.BeeDefinition;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class BlockRegister {
    public static void preInitBlocks() {
        BlockRegister.registerHives();
        BlockRegister.registerMisc();
        ExtraBees.alveary = ExtraBees.proxy.registerBlock(new BlockAlveary());
        GameRegistry.registerTileEntity(TileEntityExtraBeesAlvearyPart.class, (String)"TileEntityExtraBeesAlvearyPart");
    }

    public static void postInitBlocks() {
        BlockRegister.registerHiveDrops();
    }

    private static void registerMisc() {
        ExtraBees.ectoplasm = new BlockEctoplasm();
        GameRegistry.register((IForgeRegistryEntry)ExtraBees.ectoplasm);
    }

    private static void registerHives() {
        ExtraBees.hive = new BlockExtraBeeHive();
        GameRegistry.register((IForgeRegistryEntry)ExtraBees.hive);
    }

    private static void registerHiveDrops() {
        IAlleleBeeSpecies valiantSpecies = Utils.getSpecies(BeeDefinition.VALIANT);
        EnumHiveType.Water.drops.add(new HiveDrop(ExtraBeeDefinition.WATER, 80));
        EnumHiveType.Water.drops.add(new HiveDrop(valiantSpecies, 3));
        EnumHiveType.Rock.drops.add(new HiveDrop(ExtraBeeDefinition.ROCK, 80));
        EnumHiveType.Rock.drops.add(new HiveDrop(valiantSpecies, 3));
        EnumHiveType.Nether.drops.add(new HiveDrop(ExtraBeeDefinition.BASALT, 80));
        EnumHiveType.Nether.drops.add(new HiveDrop(valiantSpecies, 3));
        EnumHiveType.Marble.drops.add(new HiveDrop(ExtraBeeDefinition.MARBLE, 80));
        EnumHiveType.Marble.drops.add(new HiveDrop(valiantSpecies, 3));
        ExtraBees.hive.setHarvestLevel("scoop", 0, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, (Comparable)((Object)EnumHiveType.Water)));
        ExtraBees.hive.setHarvestLevel("scoop", 0, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, (Comparable)((Object)EnumHiveType.Rock)));
        ExtraBees.hive.setHarvestLevel("scoop", 0, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, (Comparable)((Object)EnumHiveType.Nether)));
        ExtraBees.hive.setHarvestLevel("scoop", 0, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, (Comparable)((Object)EnumHiveType.Marble)));
        if (!ConfigurationMain.canQuarryMineHives) {
            // empty if block
        }
    }
}

