/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.blocks;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.blocks.type.EnumHiveType;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.apiculture.IHiveTile;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.tiles.TileHive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockExtraBeeHive
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<EnumHiveType> hiveType = PropertyEnum.func_177709_a((String)"type", EnumHiveType.class);

    public BlockExtraBeeHive() {
        super(ExtraBees.materialBeehive);
        this.func_149715_a(0.2f);
        this.func_149711_c(1.0f);
        this.func_149675_a(true);
        this.setRegistryName("hive");
        this.func_149647_a(Tabs.tabApiculture);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        return "extrabees.block.hive." + itemStack.func_77952_i();
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (int i = 0; i < EnumHiveType.values().length; ++i) {
            itemList.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumHiveType)((Object)state.func_177229_b(hiveType))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(hiveType, (Comparable)((Object)EnumHiveType.values()[meta]));
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        super.func_180649_a(world, pos, player);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            hive.onAttack(world, pos, player);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHiveTile) {
            IHiveTile hive = (IHiveTile)tile;
            hive.onBroken(world, pos, player, this.canHarvestBlock((IBlockAccess)world, pos, player));
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileHive();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{hiveType});
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        IBee bee;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        List<IHiveDrop> hiveDrops = BlockExtraBeeHive.getDropsForHive(this.func_176201_c(state));
        Collections.shuffle(hiveDrops);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : hiveDrops) {
                if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
                bee = drop.getBeeType(world, pos);
                if ((double)random.nextFloat() < drop.getIgnobleChance(world, pos, fortune)) {
                    bee.setIsNatural(false);
                }
                ItemStack princess = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS);
                drops.add(princess);
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            bee = drop.getBeeType(world, pos);
            ItemStack drone = BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
            drops.add(drone);
            break;
        }
        for (IHiveDrop drop : hiveDrops) {
            if (!(random.nextDouble() < drop.getChance(world, pos, fortune))) continue;
            drops.addAll((Collection<ItemStack>)drop.getExtraItems(world, pos, fortune));
            break;
        }
        return drops;
    }

    private static List<IHiveDrop> getDropsForHive(int meta) {
        EnumHiveType hive = BlockExtraBeeHive.getHiveNameForMeta(meta);
        if (hive == null) {
            return Collections.emptyList();
        }
        return hive.drops;
    }

    @Nullable
    private static EnumHiveType getHiveNameForMeta(int meta) {
        if (meta < 0 || meta >= EnumHiveType.values().length) {
            return null;
        }
        return EnumHiveType.values()[meta];
    }
}

